/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.bytecode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.objectweb.asm.ClassReader;
import org.sonar.squid.api.CodeScanner;
import org.sonar.squid.api.CodeVisitor;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.indexer.SquidIndex;

public class BytecodeScanner implements CodeScanner {

  private SquidIndex  indexer;
  private List<AsmVisitor> asmVisitors = new ArrayList<AsmVisitor>();

  public BytecodeScanner(SquidIndex indexer) {
    this.indexer = indexer;
  }

  public void scanCode(SourceCode project, Collection<File> filesToAnalyse) {
    AsmSquidBridge asmSquidBridge = new AsmSquidBridge(indexer, asmVisitors);
    for (File file : filesToAnalyse) {
      try {
        ClassReader reader = new ClassReader(new FileInputStream(file));
        reader.accept(asmSquidBridge, 0);
      } catch (FileNotFoundException e) {
        e.printStackTrace();
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
  }

  public void accept(CodeVisitor visitor) {
    asmVisitors.add((AsmVisitor) visitor);
  }

  public Collection<Class<? extends CodeVisitor>> getVisitors() {
    List<Class<? extends CodeVisitor>> visitorClasses = new ArrayList<Class<? extends CodeVisitor>>();
    visitorClasses.add(DependencyVisitor.class);
    return visitorClasses;
  }
}
