/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.bytecode.asm;

import java.util.HashSet;
import java.util.Set;

import org.objectweb.asm.signature.SignatureVisitor;

public class AsmSignatureVisitor implements SignatureVisitor {

  private Set<String> internalNames = new HashSet<String>();

  public Set<String> getInternalNames() {
    return internalNames;
  }

  public void visitClassType(String name) {
    internalNames.add(name);
  }

  public SignatureVisitor visitArrayType() {
    return this;
  }

  public void visitBaseType(char descriptor) {
  }

  public SignatureVisitor visitClassBound() {
    return this;
  }

  public SignatureVisitor visitExceptionType() {
    return this;
  }

  public void visitFormalTypeParameter(String name) {
  }

  public void visitInnerClassType(String name) {
  }

  public SignatureVisitor visitInterface() {
    return this;
  }

  public SignatureVisitor visitInterfaceBound() {
    return this;
  }

  public SignatureVisitor visitParameterType() {
    return this;
  }

  public SignatureVisitor visitReturnType() {
    return this;
  }

  public SignatureVisitor visitSuperclass() {
    return this;
  }

  public void visitTypeArgument() {
  }

  public SignatureVisitor visitTypeArgument(char wildcard) {
    return this;
  }

  public void visitTypeVariable(String name) {
  }

  public void visitEnd() {
  }
}
