/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.text.colorizer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.sonar.squid.text.CodeReader;
import org.sonar.squid.text.EndTokenMatcher;

public class KeywordsTokenizer extends Tokenizer {

  private Set<String>     keywords        = new HashSet<String>();
  private EndTokenMatcher endTokenMatcher = new EndTokenMatcher() {

                                            public boolean match(int endFlag) {
                                              return !Character.isJavaIdentifierPart(endFlag);
                                            }
                                          };

  public KeywordsTokenizer(String tagBefore, String tagAfter, Set<String> keywords) {
    super(tagBefore, tagAfter);
    this.keywords = keywords;
  }

  public KeywordsTokenizer(String tagBefore, String tagAfter, String... keywords) {
    super(tagBefore, tagAfter);
    Collections.addAll(this.keywords, keywords);
  }

  public KeywordsTokenizer(String keyword) {
    this("", "", keyword);
  }

  @Override
  public boolean hasNextToken(CodeReader code) {
    return Character.isJavaIdentifierStart(code.peek());
  }

  @Override
  public String nextToken(CodeReader code) {
    String keyword = code.readTo(endTokenMatcher);
    return keywords.contains(keyword) ? (tagBefore + keyword + tagAfter) : keyword;
  }

}
