/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.text.colorizer;

import org.sonar.squid.text.CodeReader;
import org.sonar.squid.text.EndTokenMatcher;

public class StringTokenizer extends Tokenizer {

  public StringTokenizer(String tagBefore, String tagAfter) {
    super(tagBefore, tagAfter);
  }

  public StringTokenizer() {
    super("", "");
  }

  @Override
  public boolean hasNextToken(CodeReader code) {
    return code.peek() == '\'' || code.peek() == '\"';
  }

  @Override
  public String nextToken(CodeReader code) {
    int firstChar = code.peek();
    String comment = code.readTo(new EndCommentMatcher(firstChar, code));
    return tagBefore + comment + tagAfter;
  }

  private class EndCommentMatcher implements EndTokenMatcher {

    private final int        firstChar;
    private final CodeReader code;
    private int              stringLength = 0;

    public EndCommentMatcher(int firstChar, CodeReader code) {
      this.firstChar = firstChar;
      this.code = code;
    }

    public boolean match(int endFlag) {
      return (code.lastChar() == firstChar && code.lastChar(2) != '\\' && ++stringLength > 1);
    }
  }
}
