/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.bytecode;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.bytecode.AccessFlags;
import org.sonar.squid.bytecode.AsmVisitor;
import org.sonar.squid.bytecode.asm.AsmSignatureVisitor;
import org.sonar.squid.indexer.SquidIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmSquidBridge
extends EmptyVisitor {
    private List<AsmVisitor> visitors = new ArrayList<AsmVisitor>();
    private SourceClass currentClass;
    private final SquidIndex indexer;

    public AsmSquidBridge(SquidIndex indexer, List<AsmVisitor> asmVisitors) {
        this.indexer = indexer;
        this.visitors = asmVisitors;
    }

    public void visit(int version, int access, String className, String signature, String superClass, String[] interfaces) {
        this.currentClass = this.searchSquidClass(className);
        for (AsmVisitor visitor : this.visitors) {
            visitor.visitClass(new AccessFlags(access), this.currentClass, this.searchSquidClass(superClass), this.searchSquidClasses(interfaces), this.searchSquidClasses(this.analyzeSignature(signature)));
        }
    }

    public FieldVisitor visitField(int access, String fieldName, String fieldType, String signature, Object value) {
        for (AsmVisitor visitor : this.visitors) {
            visitor.visitField(new AccessFlags(access), this.currentClass, fieldName, this.getSquidClassFromDescriptor(fieldType), this.searchSquidClasses(this.analyzeSignature(signature)), this.analyzeFieldValue(value));
        }
        return this;
    }

    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        for (AsmVisitor visitor : this.visitors) {
            visitor.visitMethod(new AccessFlags(access), this.currentClass, methodName, this.getReturnSquidClass(methodDesc), this.getArgumentSquidClasses(methodDesc), this.searchSquidClasses(this.analyzeSignature(signature)), this.searchSquidClasses(exceptions));
        }
        return this;
    }

    public void visitFieldInsn(int opcode, String ownerClass, String name, String fieldDescription) {
        for (AsmVisitor visitor : this.visitors) {
            visitor.visitOutsideFieldAccess(this.currentClass, this.searchSquidClass(ownerClass), this.getSquidClassFromDescriptor(fieldDescription));
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        for (AsmVisitor visitor : this.visitors) {
            visitor.visitTypeInsn(this.currentClass, this.searchSquidClass(type));
        }
    }

    public void visitMethodInsn(int opcode, String ownerClass, String methodName, String methodDesc) {
        for (AsmVisitor visitor : this.visitors) {
            visitor.visitOutsideMethodAccess(this.currentClass, this.searchSquidClass(ownerClass), this.getArgumentSquidClasses(methodDesc));
        }
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String exception) {
        for (AsmVisitor visitor : this.visitors) {
            visitor.visitTryCatchBlock(this.currentClass, this.searchSquidClass(exception));
        }
    }

    private Set<SourceClass> getArgumentSquidClasses(String desc) {
        HashSet<SourceClass> resources = new HashSet<SourceClass>();
        Type[] types = Type.getArgumentTypes((String)desc);
        for (int i = 0; i < types.length; ++i) {
            resources.add(this.getSquidClassFromType(types[i]));
        }
        return resources;
    }

    private SourceClass getReturnSquidClass(String desc) {
        return this.getSquidClassFromType(Type.getReturnType((String)desc));
    }

    private SourceClass analyzeFieldValue(Object value) {
        if (value instanceof Type) {
            return this.getSquidClassFromType((Type)value);
        }
        return null;
    }

    private String[] analyzeSignature(String signature) {
        AsmSignatureVisitor signatureVisitor = new AsmSignatureVisitor();
        if (signature != null) {
            new SignatureReader(signature).accept((SignatureVisitor)signatureVisitor);
        }
        return signatureVisitor.getInternalNames().toArray(new String[0]);
    }

    private SourceClass getSquidClassFromType(Type type) {
        String className;
        switch (type.getSort()) {
            case 10: {
                className = type.getClassName();
                break;
            }
            case 9: {
                className = type.getElementType().getClassName();
                break;
            }
            default: {
                return null;
            }
        }
        return (SourceClass)this.indexer.search(className);
    }

    private SourceClass getSquidClassFromDescriptor(String typeDescription) {
        Type type = Type.getType((String)typeDescription);
        return this.getSquidClassFromType(type);
    }

    private SourceClass searchSquidClass(String internalName) {
        if (internalName == null) {
            return null;
        }
        String classNameWithoutAnonymousInnerClassExtension = this.attachAnoInnerClassToParentClass(internalName);
        return (SourceClass)this.indexer.search(Type.getObjectType((String)classNameWithoutAnonymousInnerClassExtension).getClassName());
    }

    private String attachAnoInnerClassToParentClass(String internalName) {
        if (this.indexer.search(Type.getObjectType((String)internalName).getClassName()) == null && internalName.indexOf(36) != -1 && internalName.matches(".*\\d")) {
            return internalName.substring(0, internalName.indexOf(36));
        }
        return internalName;
    }

    private Set<SourceClass> searchSquidClasses(String[] internalNames) {
        HashSet<SourceClass> resources = new HashSet<SourceClass>();
        if (internalNames == null) {
            return resources;
        }
        for (int i = 0; i < internalNames.length; ++i) {
            resources.add(this.searchSquidClass(internalNames[i]));
        }
        return resources;
    }
}

