/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.text;

import com.puppycrawl.tools.checkstyle.api.TextBlock;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.recognizer.CodeRecognizer;
import org.sonar.squid.text.Line;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Source {
    private Line[] lines;
    private CodeRecognizer codeRecognizer;
    private Set<Integer> noSonarTagLines = new HashSet<Integer>();

    public Source(String[] stringLines, CodeRecognizer codeRecognizer, TextBlock ... comments) {
        this(stringLines, codeRecognizer, Arrays.asList(comments));
    }

    public Source(String[] stringLines, CodeRecognizer codeRecognizer, Collection<TextBlock> comments) {
        this.lines = new Line[stringLines.length];
        this.codeRecognizer = codeRecognizer;
        int index = 0;
        for (String stringLine : stringLines) {
            this.lines[index++] = new Line(stringLine);
        }
        this.attachTextBlockToLine(comments);
        for (int lineIndex = 0; lineIndex < this.lines.length; ++lineIndex) {
            this.computeBlankLine(this.lines[lineIndex]);
            this.computeHeaderCommentLine(this.lines[lineIndex]);
            this.computeCommentLine(this.lines[lineIndex]);
            this.computeCommentBlankLine(this.lines[lineIndex]);
            this.computeLineOfCode(this.lines[lineIndex]);
            this.computeNoSonarTag(this.lines[lineIndex], lineIndex + 1);
        }
    }

    private void computeNoSonarTag(Line line, int lineIndex) {
        if (line.isThereNoSonarTag()) {
            this.noSonarTagLines.add(lineIndex);
        }
    }

    private void computeLineOfCode(Line line) {
        if (line.isThereCode()) {
            line.setMeasure(Metric.LINES_OF_CODE, 1);
        }
    }

    private void computeHeaderCommentLine(Line line) {
        if (line.isThereComment() && !line.isThereBlankComment() && line.isThereLicenseHeaderComment()) {
            line.setMeasure(Metric.HEADER_COMMENT_LINES, 1);
        }
    }

    private void computeCommentLine(Line line) {
        if (line.isThereComment() && !line.isThereBlankComment()) {
            if (line.isThereJavadoc() || line.isThereLicenseHeaderComment()) {
                line.setMeasure(Metric.COMMENT_LINES, 1);
                return;
            }
            boolean isCommentedOutCode = this.codeRecognizer.isLineOfCode(line.getComment());
            if (!isCommentedOutCode) {
                line.setMeasure(Metric.COMMENT_LINES, 1);
            } else {
                line.setMeasure(Metric.COMMENTED_OUT_CODE_LINES, 1);
            }
        }
    }

    private void computeBlankLine(Line line) {
        if (line.isBlank()) {
            line.setMeasure(Metric.BLANK_LINES, 1);
        }
    }

    private void computeCommentBlankLine(Line line) {
        if (line.isThereBlankComment()) {
            line.setMeasure(Metric.COMMENT_BLANK_LINES, 1);
        }
    }

    private void attachTextBlockToLine(Collection<TextBlock> comments) {
        for (TextBlock comment : comments) {
            boolean isJavadoc = comment.getText()[0].startsWith("/**");
            boolean isLicenseHeader = comment.getStartLineNo() == 1;
            for (int index = comment.getStartLineNo(); index <= comment.getEndLineNo(); ++index) {
                this.lines[index - 1].setComment(comment.getText()[index - comment.getStartLineNo()], isJavadoc, isLicenseHeader);
            }
        }
    }

    public int getMeasure(Metric metric) {
        return this.getMeasure(metric, 1, this.lines.length);
    }

    public int getMeasure(Metric metric, int fromLine, int toLine) {
        if (toLine > this.lines.length) {
            throw new IllegalStateException("There are only " + this.lines.length + " lines in the file and you're trying to reach line " + toLine);
        }
        if (fromLine < 1) {
            throw new IllegalStateException("Line index starts from 1 and not from " + fromLine);
        }
        int measure = 0;
        for (int index = fromLine; index < toLine + 1; ++index) {
            measure += this.lines[index - 1].getInt(metric);
        }
        return measure;
    }

    public Set<Integer> getNoSonarTagLines() {
        return this.noSonarTagLines;
    }
}

