/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.text.colorizer;

import org.sonar.squid.text.CodeReader;
import org.sonar.squid.text.EndTokenMatcher;
import org.sonar.squid.text.colorizer.Tokenizer;

public class StringTokenizer
extends Tokenizer {
    public StringTokenizer(String tagBefore, String tagAfter) {
        super(tagBefore, tagAfter);
    }

    public StringTokenizer() {
        super("", "");
    }

    public boolean hasNextToken(CodeReader code) {
        return code.peek() == 39 || code.peek() == 34;
    }

    public String nextToken(CodeReader code) {
        int firstChar = code.peek();
        String comment = code.readTo(new EndCommentMatcher(firstChar, code));
        return this.tagBefore + comment + this.tagAfter;
    }

    private class EndCommentMatcher
    implements EndTokenMatcher {
        private final int firstChar;
        private final CodeReader code;
        private int stringLength = 0;

        public EndCommentMatcher(int firstChar, CodeReader code) {
            this.firstChar = firstChar;
            this.code = code;
        }

        public boolean match(int endFlag) {
            return this.code.lastChar() == this.firstChar && this.code.lastChar(2) != 92 && ++this.stringLength > 1;
        }
    }
}

