/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.sonar.squid.api.CodeScanner;
import org.sonar.squid.api.CodeVisitor;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceProject;
import org.sonar.squid.api.SquidConfiguration;
import org.sonar.squid.indexer.Query;
import org.sonar.squid.indexer.SquidIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Squid {
    private MutablePicoContainer pico = new DefaultPicoContainer();
    private SourceProject project;
    private SquidIndex squidIndex;

    public Squid(SquidConfiguration conf) {
        this.pico.addComponent((Object)conf);
        this.project = new SourceProject("Project");
        this.squidIndex = new SquidIndex();
        this.squidIndex.index(this.project);
        this.pico.addComponent((Object)this.squidIndex);
    }

    public Squid() {
        this(new SquidConfiguration());
    }

    public void scanDir(Class<? extends CodeScanner> codeScanner, File dirToAnalyse) {
        if (dirToAnalyse == null) {
            throw new IllegalStateException("There is no directory to analyze as the File object is null.");
        }
        this.scanFiles(codeScanner, Squid.traverse(dirToAnalyse));
    }

    public void scanFile(Class<? extends CodeScanner> codeScanner, File fileToAnalyse) {
        if (fileToAnalyse == null) {
            throw new IllegalStateException("There is no file to analyze as the File object is null.");
        }
        HashSet<File> files = new HashSet<File>();
        files.add(fileToAnalyse);
        this.scanFiles(codeScanner, files);
    }

    public void scanFiles(Class<? extends CodeScanner> codeScanner, Collection<File> filesToAnalyse) {
        this.addToPicocontainer(codeScanner);
        CodeScanner scanner = (CodeScanner)this.pico.getComponent(codeScanner);
        for (Class<? extends CodeVisitor> visitorClasses : scanner.getVisitors()) {
            this.addToPicocontainer(visitorClasses);
            scanner.accept((CodeVisitor)this.pico.getComponent(visitorClasses));
        }
        scanner.scanCode(this.project, filesToAnalyse);
    }

    public SourceCode computeMeasures() {
        this.project.computeMeasures();
        return this.project;
    }

    private void addToPicocontainer(Class classToExpose) {
        if (this.pico.getComponent(classToExpose) == null) {
            this.pico.addComponent((Object)classToExpose);
        }
    }

    public SourceCode search(String key) {
        return this.squidIndex.search(key);
    }

    public Collection<SourceCode> search(Query ... query) {
        return this.squidIndex.search(query);
    }

    private static List<File> traverse(File aNode) {
        ArrayList<File> files = new ArrayList<File>();
        if (aNode.canRead()) {
            if (aNode.isDirectory()) {
                File[] nodes;
                for (File node : nodes = aNode.listFiles()) {
                    files.addAll(Squid.traverse(node));
                }
            } else if (aNode.isFile()) {
                files.add(aNode);
            }
        }
        return files;
    }
}

