/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;
import java.util.List;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.ast.visitor.AstVisitor;
import org.sonar.squid.measures.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVisitor
extends AstVisitor {
    private static final List<Integer> wantedTokens = Arrays.asList(14, 15, 154, 157);

    @Override
    public List<Integer> getWantedTokens() {
        return wantedTokens;
    }

    @Override
    public void visitToken(DetailAST ast) {
        String className = ast.findFirstToken(58).getText();
        SourceClass unit = this.createClassResource(className);
        unit.setStartAtLine(ast.getLineNo());
        if (this.isInterface(ast.getType())) {
            unit.setMeasure(Metric.INTERFACES, 1);
        }
        if (this.isAbstract(ast)) {
            unit.setMeasure(Metric.ABSTRACT_CLASSES, 1);
        }
    }

    private boolean isAbstract(DetailAST ast) {
        DetailAST abstractAST = ast.findFirstToken(5).findFirstToken(40);
        return abstractAST != null;
    }

    private boolean isInterface(int type) {
        return type == 15;
    }

    private SourceClass createClassResource(String className) {
        if (this.peekResource().isType(SourceClass.class)) {
            this.addResource(SourceClass.create((SourceClass)this.peekResource(), className));
        } else {
            this.addResource(SourceClass.create(this.peekParentPackage(), className));
        }
        return (SourceClass)this.peekResource();
    }

    @Override
    public void leaveToken(DetailAST ast) {
        this.popResource();
    }
}

