/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.graph;

import java.util.HashSet;
import java.util.Set;
import org.sonar.squid.graph.EdgeUsage;
import org.sonar.squid.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edge {
    private final Node from;
    private final Node to;
    private final Set<Edge> rootEdges = new HashSet<Edge>();
    private final Set<Node> rootFromNodes = new HashSet<Node>();
    private final Set<Node> rootToNodes = new HashSet<Node>();
    private final EdgeUsage usage;

    public Edge(Node from, Node to, EdgeUsage link) {
        this(from, to, link, null);
    }

    public Edge(Node from, Node to, EdgeUsage usage, Edge rootEdge) {
        this.from = from;
        this.to = to;
        this.usage = usage;
        this.addRootEdge(rootEdge);
    }

    public Node getFrom() {
        return this.from;
    }

    public Node getTo() {
        return this.to;
    }

    public boolean hasAnEdgeFromRootNode(Node rootFromNode) {
        return this.rootFromNodes.contains(rootFromNode);
    }

    public boolean hasAnEdgeToRootNode(Node rootToNode) {
        return this.rootToNodes.contains(rootToNode);
    }

    public EdgeUsage getUsage() {
        return this.usage;
    }

    public Set<Edge> getRootEdges() {
        return this.rootEdges;
    }

    public int getNumberOfRootFromNodes() {
        return this.rootFromNodes.size();
    }

    public void addRootEdge(Edge rootRelationShip) {
        if (rootRelationShip != null) {
            this.rootEdges.add(rootRelationShip);
            this.rootFromNodes.add(rootRelationShip.from);
            this.rootToNodes.add(rootRelationShip.to);
        }
    }

    public int getWeight() {
        return this.rootEdges.size();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge edge = (Edge)obj;
        return this.from.equals(edge.from) && this.to.equals(edge.to);
    }

    public int hashCode() {
        return this.from.hashCode() + this.to.hashCode() + this.usage.hashCode();
    }
}

