/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.text;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.sonar.squid.api.AnalysisException;
import org.sonar.squid.api.CodeScanner;
import org.sonar.squid.api.CodeVisitor;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SquidConfiguration;
import org.sonar.squid.measures.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTextScanner
implements CodeScanner {
    private static final char TAB_CHAR = '\t';
    private SquidConfiguration conf;

    public AbstractTextScanner(SquidConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void scanCode(SourceCode project, Collection<File> filesToAnalyse) {
        for (File textFile : filesToAnalyse) {
            project.addChild(this.analyseFile(textFile));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SourceCode analyseFile(File fileToAnalyse) {
        SourceFile sourceFile;
        LineIterator lineIterator = null;
        try {
            SourceFile resource = new SourceFile(fileToAnalyse.getName());
            AnalysisState state = new AnalysisState();
            lineIterator = FileUtils.lineIterator((File)fileToAnalyse, (String)this.conf.getCharset().name());
            while (lineIterator.hasNext()) {
                this.analyseLine(lineIterator.nextLine(), state);
            }
            resource.setMeasure(Metric.LINES, state.lines);
            resource.setMeasure(Metric.LINES_OF_CODE, state.loc);
            resource.setMeasure(Metric.BLANK_LINES, state.blankLines);
            resource.setMeasure(Metric.COMMENT_LINES, state.commentLines);
            sourceFile = resource;
        }
        catch (FileNotFoundException e) {
            try {
                throw new AnalysisException("Unable to read file : " + fileToAnalyse.getName(), e);
                catch (IOException e2) {
                    throw new AnalysisException("En error occured when analysing file : " + fileToAnalyse.getName(), e2);
                }
            }
            catch (Throwable throwable) {
                LineIterator.closeQuietly(lineIterator);
                throw throwable;
            }
        }
        LineIterator.closeQuietly((LineIterator)lineIterator);
        return sourceFile;
    }

    private void analyseLine(String line, AnalysisState state) {
        state.newLine();
        state.stopSingleLineComment();
        StringBuilder lineWithoutComment = new StringBuilder();
        if (StringUtils.isBlank((String)line)) {
            state.incrementBlankLines();
            return;
        }
        for (int i = 0; i < line.length(); ++i) {
            if (!state.multiLinesCommentStarted && this.multiLinesCommentStart(line, i)) {
                state.startMultiLinesComment();
                continue;
            }
            if (state.multiLinesCommentStarted && this.multiLinesCommentStop(line, i)) {
                state.stopMultiLinesComment();
                i += 2;
                continue;
            }
            if (this.singleLinesCommentStart(line, i)) {
                state.startSingleLineComment();
                state.stopMultiLinesComment();
                break;
            }
            if (state.multiLinesCommentStarted || state.singleLinesCommentStarted || this.isBlankCharacter(line.charAt(i))) continue;
            lineWithoutComment.append(line.charAt(i));
        }
        if (lineWithoutComment.toString().trim().length() > 0) {
            state.incrementLoc();
        }
    }

    private boolean isBlankCharacter(char character) {
        return Character.isWhitespace(character) || character == '\t';
    }

    private boolean substringEquals(String line, int index, String substring) {
        if (line.length() < index + substring.length()) {
            return false;
        }
        return line.substring(index, index + substring.length()).equals(substring);
    }

    private boolean singleLinesCommentStart(String line, int i) {
        for (SingleLineCommentDelimiter singleLines : this.getSingleLineCommentDelimiter()) {
            String startWith = singleLines.getStartWith();
            if (!this.substringEquals(line, i, startWith)) continue;
            return true;
        }
        return false;
    }

    private boolean multiLinesCommentStart(String line, int i) {
        for (MultiLinesCommentDelimiters multiLines : this.getMultiLinesCommentDelimiters()) {
            String startWith = multiLines.getStartWith();
            if (!this.substringEquals(line, i, startWith)) continue;
            return true;
        }
        return false;
    }

    private boolean multiLinesCommentStop(String line, int i) {
        for (MultiLinesCommentDelimiters multiLines : this.getMultiLinesCommentDelimiters()) {
            String endWith = multiLines.getEndWith();
            if (!this.substringEquals(line, i, endWith)) continue;
            return true;
        }
        return false;
    }

    protected final char chartAt(String line, int index) {
        if (index < line.length()) {
            return line.charAt(index);
        }
        return ' ';
    }

    protected abstract List<MultiLinesCommentDelimiters> getMultiLinesCommentDelimiters();

    protected abstract List<SingleLineCommentDelimiter> getSingleLineCommentDelimiter();

    @Override
    public void accept(CodeVisitor visitor) {
    }

    @Override
    public Collection<Class<? extends CodeVisitor>> getVisitors() {
        return new ArrayList<Class<? extends CodeVisitor>>();
    }

    protected class SingleLineCommentDelimiter {
        private final String startWith;

        protected SingleLineCommentDelimiter(String startWith) {
            this.startWith = startWith;
        }

        protected String getStartWith() {
            return this.startWith;
        }
    }

    protected class MultiLinesCommentDelimiters {
        private final String startWith;
        private final String endWith;

        protected MultiLinesCommentDelimiters(String startWith, String endWith) {
            this.startWith = startWith;
            this.endWith = endWith;
        }

        protected String getStartWith() {
            return this.startWith;
        }

        protected String getEndWith() {
            return this.endWith;
        }
    }

    protected class AnalysisState {
        int lines = 0;
        int loc = 0;
        int blankLines = 0;
        int commentLines = 0;
        boolean multiLinesCommentStarted = false;
        boolean singleLinesCommentStarted = false;

        protected AnalysisState() {
        }

        public void newLine() {
            ++this.lines;
            if (this.multiLinesCommentStarted) {
                ++this.commentLines;
            }
        }

        public void incrementLoc() {
            ++this.loc;
        }

        public void startSingleLineComment() {
            ++this.commentLines;
            this.singleLinesCommentStarted = true;
        }

        public void startMultiLinesComment() {
            ++this.commentLines;
            this.multiLinesCommentStarted = true;
        }

        public void stopMultiLinesComment() {
            this.multiLinesCommentStarted = false;
        }

        public void stopSingleLineComment() {
            this.singleLinesCommentStarted = false;
        }

        public void incrementBlankLines() {
            ++this.blankLines;
        }
    }
}

