/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.text.colorizer;

import java.util.Arrays;
import org.sonar.squid.text.CodeReader;
import org.sonar.squid.text.EndTokenMatcher;
import org.sonar.squid.text.colorizer.Tokenizer;

public abstract class MultilinesDocTokenizer
extends Tokenizer {
    private boolean commentStartedOnPreviousLine = false;
    private final char[] startToken;

    public MultilinesDocTokenizer(String startToken, String tagBefore, String tagAfter) {
        super(tagBefore, tagAfter);
        this.startToken = startToken.toCharArray();
    }

    public MultilinesDocTokenizer(String startToken) {
        this("", "", startToken);
    }

    public boolean hasNextToken(CodeReader code) {
        return code.peek() != 10 && code.peek() != 13 && (this.commentStartedOnPreviousLine || code.peek() == this.startToken[0] && Arrays.equals(code.peek(this.startToken.length), this.startToken));
    }

    public String nextToken(CodeReader code) {
        String comment = code.readTo(new JavadocEndTokenMatcher(code));
        return this.tagBefore + comment + this.tagAfter;
    }

    private class JavadocEndTokenMatcher
    implements EndTokenMatcher {
        CodeReader code;

        public JavadocEndTokenMatcher(CodeReader code) {
            this.code = code;
        }

        public boolean match(int endFlag) {
            if (this.code.lastChar() == 47 && this.code.lastChar(1) == 42) {
                MultilinesDocTokenizer.this.commentStartedOnPreviousLine = false;
                return true;
            }
            if (endFlag == 13 || endFlag == 10) {
                MultilinesDocTokenizer.this.commentStartedOnPreviousLine = true;
                return true;
            }
            return false;
        }
    }
}

