/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.java.bytecode.asm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.objectweb.asm.Opcodes;

public class AsmClass extends AsmUnit {

  private String className;
  private Map<String, AsmMethod> methods = new HashMap<String, AsmMethod>();
  private Map<String, AsmField> fields = new HashMap<String, AsmField>();

  public AsmClass(int access, String className) {
    super(access);
    this.className = className;
  }

  boolean isAbstract() {
    return (access & Opcodes.ACC_ABSTRACT) != 0;
  }

  boolean isInterface() {
    return (access & Opcodes.ACC_INTERFACE) != 0;
  }

  String getClassName() {
    return className;
  }

  void addMethod(AsmMethod asmMethod) {
    methods.put(asmMethod.getKey(), asmMethod);
  }

  Collection<AsmMethod> getMethods() {
    return methods.values();
  }

  Collection<AsmField> getFields() {
    return fields.values();
  }

  void addField(AsmField field) {
    fields.put(field.getName(), field);
  }

  AsmField getField(String fieldName) {
    return fields.get(fieldName);
  }

  AsmMethod getMethod(String key) {
    return methods.get(key);
  }
}
