/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.sonar.java.bytecode.AsmSquidBridge;
import org.sonar.java.bytecode.AsmVisitor;
import org.sonar.java.bytecode.DependencyVisitor;
import org.sonar.squid.api.AnalysisException;
import org.sonar.squid.api.CodeScanner;
import org.sonar.squid.api.CodeVisitor;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.indexer.SquidIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeScanner
implements CodeScanner {
    private SquidIndex indexer;
    private List<AsmVisitor> asmVisitors = new ArrayList<AsmVisitor>();

    public BytecodeScanner(SquidIndex indexer) {
        this.indexer = indexer;
    }

    @Override
    public void scanCode(SourceCode project, Collection<File> filesToAnalyse) {
        AsmSquidBridge asmSquidBridge = new AsmSquidBridge(this.indexer, this.asmVisitors);
        for (File file : filesToAnalyse) {
            try {
                ClassReader reader = new ClassReader((InputStream)new FileInputStream(file));
                reader.accept((ClassVisitor)asmSquidBridge, 0);
            }
            catch (Exception e) {
                throw new AnalysisException("Unable to analyze java bytecode.", e);
            }
        }
    }

    @Override
    public void accept(CodeVisitor visitor) {
        this.asmVisitors.add((AsmVisitor)visitor);
    }

    @Override
    public Collection<Class<? extends CodeVisitor>> getVisitors() {
        ArrayList<Class<? extends CodeVisitor>> visitorClasses = new ArrayList<Class<? extends CodeVisitor>>();
        visitorClasses.add(DependencyVisitor.class);
        return visitorClasses;
    }
}

