/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.asm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sonar.java.bytecode.asm.AsmField;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.asm.AsmUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmClass
extends AsmUnit {
    private String className;
    private Map<String, AsmMethod> methods = new HashMap<String, AsmMethod>();
    private Map<String, AsmField> fields = new HashMap<String, AsmField>();

    public AsmClass(int access, String className) {
        super(access);
        this.className = className;
    }

    boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    String getClassName() {
        return this.className;
    }

    void addMethod(AsmMethod asmMethod) {
        this.methods.put(asmMethod.getKey(), asmMethod);
    }

    Collection<AsmMethod> getMethods() {
        return this.methods.values();
    }

    Collection<AsmField> getFields() {
        return this.fields.values();
    }

    void addField(AsmField field) {
        this.fields.put(field.getName(), field);
    }

    AsmField getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    AsmMethod getMethod(String key) {
        return this.methods.get(key);
    }
}

