/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmClassVisitor;
import org.sonar.squid.api.AnalysisException;

public class AsmClassReader {
    public AsmClass readClass(InputStream reader) {
        try {
            AsmClassVisitor classVisitor = new AsmClassVisitor();
            ClassReader asmReader = new ClassReader(reader);
            asmReader.accept((ClassVisitor)classVisitor, 0);
            return classVisitor.getAsmClass();
        }
        catch (IOException e) {
            throw new AnalysisException("Unable to read bytecode", e);
        }
    }

    public AsmClass readClass(String className) {
        return this.readClass(ClassLoader.getSystemResourceAsStream(className));
    }

    public AsmClass readClass(File file) {
        AsmClass asmClass;
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            asmClass = this.readClass(input);
        }
        catch (FileNotFoundException e) {
            try {
                throw new AnalysisException("Unable to read file : " + file.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return asmClass;
    }
}

