/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.asm;

import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.sonar.java.bytecode.asm.AsmSignatureVisitor;
import org.sonar.java.bytecode.asm.AsmType;
import org.sonar.java.bytecode.asm.AsmUnit;

public class AsmField
extends AsmUnit {
    private String name;
    private AsmType type;
    private String[] classes;

    public AsmField(int access, String name, String descriptor, String descriptorWithGenerics) {
        super(access);
        this.access = access;
        this.name = name;
        this.type = new AsmType(Type.getType((String)descriptor));
        if (descriptorWithGenerics == null) {
            this.extractClasses(descriptor);
        } else {
            this.extractClasses(descriptorWithGenerics);
        }
    }

    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    String getName() {
        return this.name;
    }

    AsmType getType() {
        return this.type;
    }

    String getPath() {
        return this.type.getPath();
    }

    private void extractClasses(String signature) {
        if (signature != null) {
            AsmSignatureVisitor signatureVisitor = new AsmSignatureVisitor();
            new SignatureReader(signature).acceptType((SignatureVisitor)signatureVisitor);
            Set<String> internalNames = signatureVisitor.getInternalNames();
            this.classes = internalNames.toArray(new String[internalNames.size()]);
        }
    }

    String[] getClasses() {
        return this.classes;
    }

    boolean isArray() {
        return this.type.isArray();
    }

    boolean isObject() {
        return this.type.isObject();
    }

    boolean isPrimiteType() {
        return this.type.isPrimiteType();
    }
}

