/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.api;

import java.util.Observable;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeNode<E extends TreeNode>
extends Observable {
    private TreeNode parent;
    private SortedSet<E> children = new TreeSet();

    public E addChild(E resource) {
        super.setParent(this);
        if (!this.children.contains(resource)) {
            this.children.add(resource);
            this.setChanged();
            this.notifyObservers(resource);
        }
        return (E)this;
    }

    public E getParent(Class<? extends TreeNode> squidUnit) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getClass().equals(squidUnit)) {
            return (E)this.parent;
        }
        return this.parent.getParent(squidUnit);
    }

    public E getFirstChild() {
        return (E)(!this.children.isEmpty() ? (TreeNode)this.children.first() : null);
    }

    public E getLastChild() {
        return (E)(!this.children.isEmpty() ? (TreeNode)this.children.last() : null);
    }

    private void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public E getParent() {
        return (E)this.parent;
    }

    public Set<E> getChildren() {
        return this.children;
    }

    public boolean hasChild(TreeNode squidUnit) {
        if (this.children.contains(squidUnit)) {
            return true;
        }
        for (TreeNode child : this.children) {
            if (!child.hasChild(squidUnit)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAmongParents(TreeNode expectedParent) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.equals(expectedParent)) {
            return true;
        }
        return this.parent.hasAmongParents(expectedParent);
    }
}

