/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.indexer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.indexer.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SquidIndex
implements Observer {
    Map<String, SourceCode> index = new TreeMap<String, SourceCode>();

    public Collection<SourceCode> search(Query ... query) {
        HashSet<SourceCode> result = new HashSet<SourceCode>();
        for (SourceCode unit : this.index.values()) {
            if (!this.isSquidUnitMatchQueries(unit, query)) continue;
            result.add(unit);
        }
        return result;
    }

    private boolean isSquidUnitMatchQueries(SourceCode unit, Query ... query) {
        for (int i = 0; i < query.length; ++i) {
            boolean match = query[i].match(unit);
            if (match) continue;
            return false;
        }
        return true;
    }

    public SourceCode search(String key) {
        return this.index.get(key);
    }

    public void index(SourceCode project) {
        project.addObserver(this);
        this.index.put(project.getKey(), project);
    }

    @Override
    public void update(Observable parentResource, Object resourceAdded) {
        if (!(resourceAdded instanceof SourceCode)) {
            throw new IllegalStateException("ResourceIndexer expected a Resource object but get a : " + resourceAdded.getClass().getName());
        }
        SourceCode resource = (SourceCode)resourceAdded;
        resource.addObserver(this);
        this.index.put(resource.getKey(), resource);
    }
}

