/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.ast.CheckstyleSquidBridge;
import org.sonar.java.ast.visitor.AccessorVisitor;
import org.sonar.java.ast.visitor.AnonymousInnerClassVisitor;
import org.sonar.java.ast.visitor.AstVisitor;
import org.sonar.java.ast.visitor.BlankLinesVisitor;
import org.sonar.java.ast.visitor.BranchVisitor;
import org.sonar.java.ast.visitor.ClassVisitor;
import org.sonar.java.ast.visitor.CommentVisitor;
import org.sonar.java.ast.visitor.ComplexityVisitor;
import org.sonar.java.ast.visitor.EndAtLineVisitor;
import org.sonar.java.ast.visitor.FileVisitor;
import org.sonar.java.ast.visitor.LinesOfCodeVisitor;
import org.sonar.java.ast.visitor.LinesVisitor;
import org.sonar.java.ast.visitor.MethodVisitor;
import org.sonar.java.ast.visitor.PackageVisitor;
import org.sonar.java.ast.visitor.PublicApiVisitor;
import org.sonar.java.ast.visitor.StatementVisitor;
import org.sonar.squid.Squid;
import org.sonar.squid.api.AnalysisException;
import org.sonar.squid.api.CodeScanner;
import org.sonar.squid.api.CodeVisitor;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SquidConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAstScanner
implements CodeScanner {
    private SquidConfiguration conf;
    private List<AstVisitor> visitors = new ArrayList<AstVisitor>();

    public JavaAstScanner(SquidConfiguration conf) {
        this.conf = conf;
    }

    private void launchCheckstyleEngine(Collection<File> files, Charset charset) {
        ErrorsListener listener = new ErrorsListener();
        Checker c = this.createChecker(charset, listener);
        File[] processedFiles = new File[files.size()];
        files.toArray(processedFiles);
        c.process(processedFiles);
        c.destroy();
        if (!listener.getErrors().isEmpty()) {
            throw listener.getErrors().get(0);
        }
    }

    private Checker createChecker(Charset charset, ErrorsListener errorsListener) {
        try {
            InputStream checkstyleConfig = JavaAstScanner.class.getClassLoader().getResourceAsStream("checkstyle-configuration.xml");
            String readenConfig = IOUtils.toString((InputStream)checkstyleConfig);
            readenConfig = readenConfig.replace("${charset}", charset.toString());
            checkstyleConfig = new ByteArrayInputStream(readenConfig.getBytes());
            Configuration config = ConfigurationLoader.loadConfiguration((InputStream)checkstyleConfig, (PropertyResolver)new PropertiesExpander(System.getProperties()), (boolean)false);
            Checker c = new Checker();
            c.configure(config);
            final Logger logger = LoggerFactory.getLogger(Squid.class);
            StreamLogger infoLogger = new StreamLogger(){

                public void log(String log) {
                    logger.info(log);
                }
            };
            StreamLogger errorLogger = new StreamLogger(){

                public void log(String log) {
                    logger.error(log);
                }
            };
            c.addListener((AuditListener)new DefaultLogger((OutputStream)infoLogger, true, (OutputStream)errorLogger, true));
            c.addListener((AuditListener)errorsListener);
            return c;
        }
        catch (Exception e) {
            throw new AnalysisException("Unable to create Checkstyle Checker object with 'checkstyle-configuration.xml' as Checkstyle configuration file name", e);
        }
    }

    @Override
    public void scanCode(SourceCode project, Collection<File> filesToAnalyse) {
        Stack<SourceCode> resourcesStack = new Stack<SourceCode>();
        resourcesStack.add(project);
        for (AstVisitor visitor : this.visitors) {
            visitor.setResourcesStack(resourcesStack);
        }
        CheckstyleSquidBridge.setASTVisitors(this.visitors);
        CheckstyleSquidBridge.setSquidConfiguration(this.conf);
        this.launchCheckstyleEngine(filesToAnalyse, this.conf.getCharset());
    }

    @Override
    public void accept(CodeVisitor visitor) {
        this.visitors.add((AstVisitor)visitor);
    }

    @Override
    public Collection<Class<? extends CodeVisitor>> getVisitors() {
        ArrayList<Class<? extends CodeVisitor>> visitorClasses = new ArrayList<Class<? extends CodeVisitor>>();
        visitorClasses.add(PackageVisitor.class);
        visitorClasses.add(FileVisitor.class);
        visitorClasses.add(ClassVisitor.class);
        visitorClasses.add(AnonymousInnerClassVisitor.class);
        visitorClasses.add(MethodVisitor.class);
        visitorClasses.add(EndAtLineVisitor.class);
        visitorClasses.add(LinesVisitor.class);
        visitorClasses.add(BlankLinesVisitor.class);
        visitorClasses.add(CommentVisitor.class);
        visitorClasses.add(PublicApiVisitor.class);
        visitorClasses.add(BranchVisitor.class);
        visitorClasses.add(StatementVisitor.class);
        if (this.conf.isAnalysePropertyAccessors()) {
            visitorClasses.add(AccessorVisitor.class);
        }
        visitorClasses.add(ComplexityVisitor.class);
        visitorClasses.add(LinesOfCodeVisitor.class);
        return visitorClasses;
    }

    private static abstract class StreamLogger
    extends OutputStream {
        private StringBuilder builder = new StringBuilder(256);

        private StreamLogger() {
        }

        public void write(int byteToWrite) throws IOException {
            char character = (char)byteToWrite;
            if (character == '\n') {
                this.logAndResetBuffer();
            } else {
                this.builder.append(character);
            }
        }

        private void logAndResetBuffer() {
            this.log(this.builder.toString().trim());
            this.builder.setLength(0);
        }

        public abstract void log(String var1);

        public void close() throws IOException {
            if (this.builder.length() > 0) {
                this.logAndResetBuffer();
            }
            super.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorsListener
    implements AuditListener {
        private List<AnalysisException> errors = new ArrayList<AnalysisException>();

        private ErrorsListener() {
        }

        public void addError(AuditEvent evt) {
            if (evt.getMessage().contains("expecting EOF, found")) {
                return;
            }
            this.errors.add(new AnalysisException(evt.getMessage()));
        }

        public void addException(AuditEvent evt, Throwable throwable) {
            this.errors.add(new AnalysisException(evt.getMessage(), throwable));
        }

        public void auditFinished(AuditEvent evt) {
        }

        public void auditStarted(AuditEvent evt) {
        }

        public void fileFinished(AuditEvent evt) {
        }

        public void fileStarted(AuditEvent evt) {
        }

        public List<AnalysisException> getErrors() {
            return this.errors;
        }
    }
}

