/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;
import java.util.List;
import org.sonar.java.ast.visitor.AstUtils;
import org.sonar.java.ast.visitor.AstVisitor;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.measures.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnonymousInnerClassVisitor
extends AstVisitor {
    private static final List<Integer> wantedTokens = Arrays.asList(6);

    @Override
    public List<Integer> getWantedTokens() {
        return wantedTokens;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!AstUtils.isClass(ast.getParent())) {
            int anonymousInnerClassNo = this.determineAnonymousInnerClassNo(this.peekParentClass());
            String anonymousInnerClassName = this.peekParentClass().getName() + "$" + anonymousInnerClassNo;
            String anonymousInnerClassKey = this.peekParentClass().getKey() + "$" + anonymousInnerClassNo;
            SourceClass anonymousInnerClass = new SourceClass(anonymousInnerClassKey, anonymousInnerClassName);
            anonymousInnerClass.setStartAtLine(ast.getLineNo());
            anonymousInnerClass.setMeasure(Metric.ANONYMOUS_INNER_CLASSES, 1);
            this.addResource(anonymousInnerClass);
        }
    }

    private int determineAnonymousInnerClassNo(SourceClass parentClass) {
        int anonymousInnerClassNo = 1;
        SourceClass anonymousInnerClass;
        while (parentClass.hasChild(anonymousInnerClass = new SourceClass(parentClass.getKey() + "$" + anonymousInnerClassNo))) {
            ++anonymousInnerClassNo;
        }
        return anonymousInnerClassNo;
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (!AstUtils.isClass(ast.getParent())) {
            this.popResource();
        }
    }
}

