/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.sonar.squid.api.TreeNode;
import org.sonar.squid.graph.Edge;
import org.sonar.squid.graph.EdgeUsage;
import org.sonar.squid.graph.Node;
import org.sonar.squid.measures.Measurable;
import org.sonar.squid.measures.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceCode
extends TreeNode<SourceCode>
implements Node,
Measurable,
Comparable<SourceCode> {
    private final String name;
    private Map<Metric, Double> measures = new HashMap<Metric, Double>();
    private final String key;
    private Map<Node, Edge> dependedUpon = new HashMap<Node, Edge>();
    private Map<Node, Edge> dependsUpon = new HashMap<Node, Edge>();
    private int startAtLine = -1;
    private int endAtLine = -1;

    public SourceCode(String key) {
        this(key, null);
    }

    public SourceCode(String key, String name) {
        this.name = name;
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int compareTo(SourceCode resource) {
        return this.key.compareTo(resource.getKey());
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SourceCode)) {
            return false;
        }
        return this.getKey().equals(((SourceCode)obj).getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.getClass().getSimpleName()).append(" : ").append(this.getKey()).append(IOUtils.LINE_SEPARATOR);
        for (SourceCode child : this.getChildren()) {
            String childTree = child.toString();
            StringTokenizer tokenizer = new StringTokenizer(childTree, IOUtils.LINE_SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                sb.append("-").append(tokenizer.nextToken()).append(IOUtils.LINE_SEPARATOR);
            }
        }
        return sb.toString();
    }

    public final void computeMeasures() {
        for (SourceCode child : this.getChildren()) {
            child.computeMeasures();
        }
        for (Metric metric : Metric.values()) {
            if (!metric.aggregateIfThereIsAlreadyAValue() && this.getDouble(metric) != 0.0) continue;
            for (SourceCode child : this.getChildren()) {
                if (metric.isCalculatedMetric() || !metric.isThereAggregationFormula()) continue;
                this.add(metric, child);
            }
        }
    }

    @Override
    public void createEdgeWith(Node to, EdgeUsage link) {
        this.createEdgeWith(to, link, null);
    }

    @Override
    public void createEdgeWith(Node to, EdgeUsage link, Edge rootEdge) {
        if (this.equals(to)) {
            throw new IllegalStateException("You can't create an edge from one node to itself. SquidUnit : " + this.getKey());
        }
        if (this.getEdgeTo(to) != null) {
            throw new IllegalStateException("Those two nodes are already linked. From : " + this.getKey() + ", To : " + to.getKey());
        }
        Edge edge = new Edge(this, to, link, null);
        edge.addRootEdge(rootEdge);
        this.dependsUpon.put(to, edge);
        ((SourceCode)to).dependedUpon.put(this, edge);
    }

    @Override
    public Edge getEdgeTo(Node to) {
        return this.dependsUpon.get(to);
    }

    @Override
    public Edge getEdgeFrom(Node from) {
        return this.dependedUpon.get(from);
    }

    @Override
    public EdgeUsage getUsageOf(Node to) {
        Edge relation = this.dependsUpon.get(to);
        if (relation == null) {
            return EdgeUsage.NO_LINK;
        }
        return relation.getUsage();
    }

    @Override
    public EdgeUsage getUsageBy(Node from) {
        Edge edge = this.dependedUpon.get(from);
        if (edge == null) {
            return EdgeUsage.NO_LINK;
        }
        return edge.getUsage();
    }

    @Override
    public Set<Node> dependedUpon() {
        return this.dependedUpon.keySet();
    }

    @Override
    public Set<Node> dependsUpon() {
        return this.dependsUpon.keySet();
    }

    public boolean isType(Class<? extends SourceCode> resourceType) {
        return this.getClass() == resourceType;
    }

    @Override
    public int getInt(Metric metric) {
        return this.getMeasure(metric).intValue();
    }

    @Override
    public double getDouble(Metric metric) {
        return this.getMeasure(metric);
    }

    public void add(Metric metric, SourceCode child) {
        this.add(metric, child.getMeasure(metric));
    }

    public void add(Metric metric, double value) {
        this.setMeasure(metric, this.getMeasure(metric) + value);
    }

    private Double getMeasure(Metric metric) {
        if (metric.isCalculatedMetric()) {
            return metric.getCalculatedMetricFormula().calculate(this);
        }
        if (this.measures.get((Object)metric) == null) {
            return 0.0;
        }
        return this.measures.get((Object)metric);
    }

    @Override
    public void setMeasure(Metric metric, double measure) {
        if (metric.isCalculatedMetric()) {
            throw new IllegalStateException("It's not allowed to set the value of a calculated metric : " + metric.name());
        }
        this.measures.put(metric, measure);
    }

    @Override
    public void setMeasure(Metric metric, int measure) {
        this.setMeasure(metric, (double)measure);
    }

    public void setStartAtLine(int startAtLine) {
        this.startAtLine = startAtLine;
        this.endAtLine = startAtLine;
    }

    public void setEndAtLine(int endAtLine) {
        this.endAtLine = endAtLine;
    }

    public int getStartAtLine() {
        return this.startAtLine;
    }

    public int getEndAtLine() {
        return this.endAtLine;
    }
}

