/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.math;

import org.sonar.squid.api.SourceCode;
import org.sonar.squid.measures.Metric;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class MeasuresDistribution {

  private final Collection<SourceCode> units;

  public MeasuresDistribution(Collection<SourceCode> units) {
    this.units = units;
  }

  public Map<Integer, Integer> distributeAccordingTo(Metric metric, int... thresholds) {
    Map<Integer, Integer> result = new TreeMap<Integer, Integer>();
    for (int threshold : thresholds) {
      result.put(threshold, 0);
    }
    for (SourceCode unit : units) {
      for (int index = 0; index < thresholds.length; index++) {
        if (isInFirstRange(index, unit.getDouble(metric), thresholds[index])) {
          result.put(thresholds[0], result.get(thresholds[0]) + 1);
          break;
        } else if (unit.getDouble(metric) < thresholds[index]) {
          result.put(thresholds[index - 1], result.get(thresholds[index - 1]) + 1);
          break;
        } else if (isLastRange(index, thresholds)) {
          result.put(thresholds[index], result.get(thresholds[index]) + 1);
        }
      }
    }
    return result;
  }

  private boolean isLastRange(int index, int[] thresholds) {
    return index == thresholds.length - 1;
  }

  private boolean isInFirstRange(int index, double measure, int threshold) {
    return index == 0 && measure < threshold;
  }
}
