/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.recognizer;

import java.util.HashSet;
import java.util.Set;

public class PlsqlFootprint implements LanguageFootprint {

  private final Set<Detector> detectors = new HashSet<Detector>();

  public PlsqlFootprint() {
    detectors.add(new EndWithDetector(0.95, ';'));
    detectors.add(new EndWithDetector(0.7, ',', '('));
    detectors.add(new ContainsDetector(0.95, "++", ":=", "||", "&&", "=>"));
    detectors.add(new ContainsDetector(0.9, "DBMS", "%"));
    detectors.add(new KeywordsDetector(0.95, true, "ELSEIF"));
    detectors.add(new KeywordsDetector(0.5, true, "PROCEDURE", "FUNCTION", "SELECT", "IN", "OUT", "VARCHAR2", "DECLARE", "NUMBER", "DATE",
        "INTO", "FROM", "WHERE", "END", "CREATE", "REPLACE", "EXCEPTION", "RECORD", "CURSOR", "LOOP", "EXIT", "DBMS_OUTPUT", "NULL",
        "COMMIT", "LOOP", "UPDATE", "CONSTANT", "EXECUTE", "PACKAGE", "RESULTS"));
  }

  public Set<Detector> getDetectors() {
    return detectors;
  }
}
