/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.java.ast.visitor.AstVisitor;
import org.sonar.java.language.ArgumentAndReturnType;
import org.sonar.java.language.ArgumentType;
import org.sonar.java.language.JavaMethodSignature;
import org.sonar.java.language.JavaType;
import org.sonar.java.language.ReturnType;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.measures.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodVisitor
extends AstVisitor {
    private static final String CONSTRUCTOR = "<init>";
    private static final List<Integer> wantedTokens = Arrays.asList(8, 9);
    private static final Map<Integer, JavaType> tokenJavaTypeMapping = new HashMap<Integer, JavaType>();

    @Override
    public List<Integer> getWantedTokens() {
        return wantedTokens;
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean isConstructor = this.isConstructor(ast);
        String methodName = this.buildMethodSignature(ast, isConstructor);
        SourceMethod sourceMethod = new SourceMethod(this.peekParentClass(), methodName, ast.getLineNo());
        sourceMethod.setMeasure(Metric.METHODS, 1);
        if (isConstructor) {
            sourceMethod.setMeasure(Metric.CONSTRUCTORS, 1);
        }
        this.addResource(sourceMethod);
    }

    private boolean isConstructor(DetailAST ast) {
        return ast.getType() == 8;
    }

    @Override
    public void leaveToken(DetailAST ast) {
        this.popResource();
    }

    private String buildMethodSignature(DetailAST ast, boolean isConstructor) {
        String methodName = this.extractMethodName(ast, isConstructor);
        ReturnType returnType = this.extractMethodReturnType(ast, isConstructor);
        List<ArgumentType> argumentTypes = this.extractMethodArgumentTypes(ast);
        JavaMethodSignature signature = new JavaMethodSignature(methodName, returnType, argumentTypes);
        return signature.dumpMethodSignature();
    }

    private List<ArgumentType> extractMethodArgumentTypes(DetailAST ast) {
        ArrayList<ArgumentType> argumentTypes = new ArrayList<ArgumentType>();
        for (DetailAST child = ast.findFirstToken(20).findFirstToken(21); child != null; child = (DetailAST)child.getNextSibling()) {
            if (child.getType() != 21) continue;
            ArgumentAndReturnType argumentType = this.extractArgumentAndRreturnType(child.findFirstToken(13));
            argumentTypes.add(new ArgumentType(argumentType));
        }
        return argumentTypes;
    }

    private String extractMethodName(DetailAST ast, boolean isConstructor) {
        if (isConstructor) {
            return CONSTRUCTOR;
        }
        return ast.findFirstToken(58).getText();
    }

    private ReturnType extractMethodReturnType(DetailAST ast, boolean isConstructor) {
        if (isConstructor) {
            return null;
        }
        ArgumentAndReturnType returnType = this.extractArgumentAndRreturnType(ast.findFirstToken(13));
        return new ReturnType(returnType);
    }

    private ArgumentAndReturnType extractArgumentAndRreturnType(DetailAST ast) {
        boolean isArray = this.isArrayType(ast);
        for (Integer tokenType : tokenJavaTypeMapping.keySet()) {
            if (!ast.branchContains(tokenType.intValue())) continue;
            return new ArgumentAndReturnType(tokenJavaTypeMapping.get(tokenType), isArray);
        }
        if (this.isObjectType(ast)) {
            String className = isArray ? this.extractClassName(ast.findFirstToken(17)) : this.extractClassName(ast);
            return new ArgumentAndReturnType(className, isArray);
        }
        throw new IllegalStateException("No Known TokenType has been found at line " + ast.getLineNo() + " of file " + this.getFileContents().getFilename());
    }

    private String extractClassName(DetailAST ast) {
        if (ast.findFirstToken(59) != null) {
            return ast.findFirstToken(59).getLastChild().getText();
        }
        return ast.findFirstToken(58).getText();
    }

    private boolean isObjectType(DetailAST ast) {
        return ast.branchContains(58);
    }

    private boolean isArrayType(DetailAST ast) {
        if (ast.findFirstToken(58) != null) {
            return false;
        }
        return ast.branchContains(17);
    }

    static {
        tokenJavaTypeMapping.put(51, JavaType.BYTE);
        tokenJavaTypeMapping.put(52, JavaType.CHAR);
        tokenJavaTypeMapping.put(53, JavaType.SHORT);
        tokenJavaTypeMapping.put(54, JavaType.INT);
        tokenJavaTypeMapping.put(56, JavaType.LONG);
        tokenJavaTypeMapping.put(50, JavaType.BOOLEAN);
        tokenJavaTypeMapping.put(55, JavaType.FLOAT);
        tokenJavaTypeMapping.put(57, JavaType.DOUBLE);
        tokenJavaTypeMapping.put(49, JavaType.VOID);
    }
}

