/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode;

import java.util.Set;
import org.sonar.java.bytecode.AccessFlags;
import org.sonar.java.bytecode.AsmVisitor;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.graph.Edge;
import org.sonar.squid.graph.EdgeUsage;
import org.sonar.squid.measures.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyVisitor
extends AsmVisitor {
    @Override
    protected void visitClass(AccessFlags accessFlags, SourceClass currentClass, SourceClass superClass, Set<SourceClass> interfaces, Set<SourceClass> generics) {
        this.link(currentClass, superClass, EdgeUsage.EXTENDS);
        this.link(currentClass, interfaces, EdgeUsage.IMPLEMENTS);
        this.link(currentClass, generics, EdgeUsage.CONTAINS);
    }

    @Override
    public void visitField(AccessFlags accessFlags, SourceClass currentClass, String fieldName, SourceClass fieldResource, Set<SourceClass> generics, SourceClass value) {
        this.link(currentClass, fieldResource, EdgeUsage.CONTAINS);
        this.link(currentClass, generics, EdgeUsage.CONTAINS);
        this.link(currentClass, value, EdgeUsage.USES);
    }

    @Override
    public void visitMethod(AccessFlags accessFlags, SourceClass currentClass, String methodName, SourceClass returnResource, Set<SourceClass> argResources, Set<SourceClass> generics, Set<SourceClass> exceptions) {
        this.link(currentClass, returnResource, EdgeUsage.USES);
        this.link(currentClass, argResources, EdgeUsage.USES);
        this.link(currentClass, generics, EdgeUsage.USES);
        this.link(currentClass, exceptions, EdgeUsage.USES);
    }

    @Override
    public void visitOutsideFieldAccess(SourceClass currentClass, SourceClass fieldOwner, SourceClass fieldType) {
        this.link(currentClass, fieldOwner, EdgeUsage.USES);
        this.link(currentClass, fieldType, EdgeUsage.USES);
    }

    @Override
    public void visitTypeInsn(SourceClass currentClass, SourceClass usedClass) {
        this.link(currentClass, usedClass, EdgeUsage.USES);
    }

    @Override
    public void visitOutsideMethodAccess(SourceClass currentClass, SourceClass outsideClass, Set<SourceClass> methodArgs) {
        this.link(currentClass, outsideClass, EdgeUsage.USES);
        this.link(currentClass, methodArgs, EdgeUsage.USES);
    }

    @Override
    public void visitTryCatchBlock(SourceClass currentClass, SourceClass exceptionClass) {
        this.link(currentClass, exceptionClass, EdgeUsage.USES);
    }

    private void link(SourceClass from, Set<SourceClass> tos, EdgeUsage link) {
        for (SourceClass to : tos) {
            this.link(from, to, link);
        }
    }

    private void link(SourceClass from, SourceClass to, EdgeUsage link) {
        if (this.canWeLinkNodes(from, to) && from.getEdgeTo(to) == null) {
            from.createEdgeWith(to, link);
            from.add(Metric.CE, 1.0);
            to.add(Metric.CA, 1.0);
            this.createEdgeBetweenParents(SourceFile.class, from, to, from.getEdgeTo(to));
            this.createEdgeBetweenParents(SourcePackage.class, from, to, from.getEdgeTo(to));
        }
    }

    private void createEdgeBetweenParents(Class<? extends SourceCode> type, SourceClass from, SourceClass to, Edge rootEdge) {
        SourceCode toParent;
        SourceCode fromParent = (SourceCode)from.getParent(type);
        if (this.canWeLinkNodes(fromParent, toParent = (SourceCode)to.getParent(type))) {
            if (fromParent.getEdgeTo(toParent) == null) {
                fromParent.createEdgeWith(toParent, EdgeUsage.USES, rootEdge);
                fromParent.add(Metric.CE, 1.0);
                toParent.add(Metric.CA, 1.0);
            } else {
                if (!fromParent.getEdgeTo(toParent).hasAnEdgeFromRootNode(from)) {
                    toParent.add(Metric.CA, 1.0);
                }
                if (!fromParent.getEdgeTo(toParent).hasAnEdgeToRootNode(to)) {
                    fromParent.add(Metric.CE, 1.0);
                }
                fromParent.getEdgeTo(toParent).addRootEdge(rootEdge);
            }
        }
    }

    private boolean canWeLinkNodes(SourceCode from, SourceCode to) {
        boolean result = from != null && to != null && !from.equals(to);
        return result;
    }
}

