/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.language;

import org.sonar.java.language.JavaType;

public class ArgumentAndReturnType {
    private final JavaType javaType;
    private final String classCanonicalName;
    private final boolean isArray;

    public ArgumentAndReturnType(JavaType javaType, boolean isArray) {
        this(javaType, null, isArray);
    }

    public ArgumentAndReturnType(String classCanonicalName, boolean isArray) {
        this(JavaType.OBJECT, classCanonicalName, isArray);
    }

    ArgumentAndReturnType(JavaType javaType, String classCanonicalName, boolean isArray) {
        if (javaType == JavaType.OBJECT && (classCanonicalName == null || classCanonicalName.equals(""))) {
            throw new IllegalStateException("With an Object JavaType, this is mandatory to specify the canonical name of the class.");
        }
        this.javaType = javaType;
        this.classCanonicalName = classCanonicalName;
        this.isArray = isArray;
    }

    public ArgumentAndReturnType(ArgumentAndReturnType argumentAndReturnType) {
        this(argumentAndReturnType.javaType, argumentAndReturnType.classCanonicalName, argumentAndReturnType.isArray);
    }

    public boolean isVoid() {
        return this.javaType == JavaType.VOID;
    }

    public JavaType getJavaType() {
        return this.javaType;
    }

    public String getClassCanonicalName() {
        return this.classCanonicalName;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isOject() {
        return this.javaType == JavaType.OBJECT;
    }
}

