/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.language;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.java.language.ArgumentAndReturnType;
import org.sonar.java.language.ArgumentType;
import org.sonar.java.language.JavaType;
import org.sonar.java.language.ReturnType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethodSignature {
    private final String methodName;
    private final ReturnType returnType;
    private final List<ArgumentType> argumentTypes;
    private final boolean isConstructor;
    private static Map<String, JavaType> javaTypes = new Hashtable<String, JavaType>();
    private static final char ARRAY = '[';

    public JavaMethodSignature(String methodName, ReturnType returnType, ArgumentType ... argumentTypes) {
        this(methodName, returnType, Arrays.asList(argumentTypes));
    }

    public JavaMethodSignature(String methodName, ReturnType returnType, List<ArgumentType> argumentTypes) {
        this.methodName = methodName;
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
        this.isConstructor = returnType == null;
    }

    public static JavaMethodSignature create(String methodSignature) {
        int leftBracketIndex = methodSignature.indexOf(40);
        int rightBracketIndex = methodSignature.indexOf(41);
        String methodName = methodSignature.substring(0, leftBracketIndex);
        ReturnType returnType = JavaMethodSignature.extractReturnType(methodSignature.substring(rightBracketIndex + 1));
        List<ArgumentType> argumentTypes = JavaMethodSignature.extractArgumentTypes(methodSignature.substring(leftBracketIndex + 1, rightBracketIndex));
        return new JavaMethodSignature(methodName, returnType, argumentTypes);
    }

    static List<ArgumentType> extractArgumentTypes(String argumentTypesSignature) {
        ArrayList<ArgumentType> argumentTypes = new ArrayList<ArgumentType>();
        int argumentTypeStartIndex = 0;
        int argumentTypeEndIndex = 0;
        while ((argumentTypeEndIndex = argumentTypesSignature.indexOf(59, argumentTypeStartIndex)) != -1) {
            ArgumentType argumentAndReturnType = JavaMethodSignature.extractArgumentType(argumentTypesSignature.substring(argumentTypeStartIndex, argumentTypeEndIndex));
            argumentTypes.add(argumentAndReturnType);
            argumentTypeStartIndex = argumentTypeEndIndex + 1;
        }
        return argumentTypes;
    }

    private static ArgumentType extractArgumentType(String argumentTypeSignature) {
        return new ArgumentType(JavaMethodSignature.extractType(argumentTypeSignature));
    }

    private static ReturnType extractReturnType(String returnTypeSignature) {
        if (StringUtils.isBlank((String)returnTypeSignature)) {
            return null;
        }
        return new ReturnType(JavaMethodSignature.extractType(returnTypeSignature));
    }

    static ArgumentAndReturnType extractType(String stringTypeSignature) {
        boolean isArray = false;
        int index = 0;
        String classCanonicalName = null;
        if (stringTypeSignature.charAt(0) == '[') {
            isArray = true;
            ++index;
        }
        JavaType javaType = javaTypes.get(stringTypeSignature.substring(index, index + 1));
        ++index;
        if (javaType == JavaType.OBJECT) {
            classCanonicalName = stringTypeSignature.substring(index);
            classCanonicalName = StringUtils.remove((String)classCanonicalName, (char)';');
        }
        return new ArgumentType(javaType, classCanonicalName, isArray);
    }

    public String dumpMethodSignature() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.methodName);
        builder.append("(");
        for (ArgumentType argumentType : this.argumentTypes) {
            builder.append(JavaMethodSignature.dumpTypeSignature(argumentType));
            builder.append(';');
        }
        builder.append(")");
        if (!this.isConstructor) {
            builder.append(JavaMethodSignature.dumpTypeSignature(this.returnType));
            if (!this.returnType.isVoid()) {
                builder.append(";");
            }
        }
        return builder.toString();
    }

    static String dumpTypeSignature(ArgumentAndReturnType argumentType) {
        String result = "";
        if (argumentType.isArray()) {
            result = result + '[';
        }
        result = result + argumentType.getJavaType().JVMTypeIdentifier;
        if (argumentType.isOject()) {
            result = result + argumentType.getClassCanonicalName();
        }
        return result;
    }

    static {
        for (JavaType javaType : Arrays.asList(JavaType.values())) {
            javaTypes.put(javaType.JVMTypeIdentifier, javaType);
        }
    }
}

