/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.math;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.measures.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasuresDistribution {
    private final Collection<SourceCode> units;

    public MeasuresDistribution(Collection<SourceCode> units) {
        this.units = units;
    }

    public Map<Integer, Integer> distributeAccordingTo(Metric metric, int ... thresholds) {
        TreeMap<Integer, Integer> result = new TreeMap<Integer, Integer>();
        for (int threshold : thresholds) {
            result.put(threshold, 0);
        }
        block1: for (SourceCode unit : this.units) {
            for (int index = 0; index < thresholds.length; ++index) {
                if (this.isInFirstRange(index, unit.getDouble(metric), thresholds[index])) {
                    result.put(thresholds[0], (Integer)result.get(thresholds[0]) + 1);
                    continue block1;
                }
                if (unit.getDouble(metric) < (double)thresholds[index]) {
                    result.put(thresholds[index - 1], (Integer)result.get(thresholds[index - 1]) + 1);
                    continue block1;
                }
                if (!this.isLastRange(index, thresholds)) continue;
                result.put(thresholds[index], (Integer)result.get(thresholds[index]) + 1);
            }
        }
        return result;
    }

    private boolean isLastRange(int index, int[] thresholds) {
        return index == thresholds.length - 1;
    }

    private boolean isInFirstRange(int index, double measure, int threshold) {
        return index == 0 && measure < (double)threshold;
    }
}

