/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.java.bytecode;

import java.util.Set;

import org.sonar.squid.api.CodeVisitor;
import org.sonar.squid.api.SourceClass;

public abstract class AsmVisitor implements CodeVisitor {

  protected abstract void visitClass(AccessFlags accessFlags, SourceClass currentClass, SourceClass superClass, Set<SourceClass> intefaces,
      Set<SourceClass> generics);

  public abstract void visitField(AccessFlags accessFlags, SourceClass currentClass, String fieldName, SourceClass fieldResource,
      Set<SourceClass> generics, SourceClass value);

  public abstract void visitMethod(AccessFlags accessFlags, SourceClass currentClass, String methodName, SourceClass returnResource,
      Set<SourceClass> argResources, Set<SourceClass> generics, Set<SourceClass> exceptions);

  public abstract void visitOutsideFieldAccess(SourceClass currentClass, SourceClass outsideClass, SourceClass fieldType);

  public abstract void visitTypeInsn(SourceClass currentClass, SourceClass usedClass);

  public abstract void visitOutsideMethodAccess(SourceClass currentClass, SourceClass outsideClass, Set<SourceClass> methodArgs);

  public abstract void visitTryCatchBlock(SourceClass currentClass, SourceClass exceptionClass);
}
