/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.java.bytecode.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.sonar.squid.api.AnalysisException;

public class AsmClassReader {

  public AsmClass readClass(InputStream reader) {
    try {
      AsmClassVisitor classVisitor = new AsmClassVisitor();
      ClassReader asmReader = new ClassReader(reader);
      asmReader.accept(classVisitor, 0);
      return classVisitor.getAsmClass();
    } catch (IOException e) {
      throw new AnalysisException("Unable to read bytecode", e);
    }
  }

  public AsmClass readClass(String className) {
    return readClass(ClassLoader.getSystemResourceAsStream(className));
  }

  public AsmClass readClass(File file) {
    FileInputStream input = null;
    try {
      input = new FileInputStream(file);
      return readClass(input);
      
    } catch (FileNotFoundException e) {
      throw new AnalysisException("Unable to read file : " + file.getAbsolutePath(), e);

    } finally {
      IOUtils.closeQuietly(input);
    }
  }
}
