/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.java.bytecode.asm;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class AsmClassVisitor extends EmptyVisitor {

  private AsmClass asmClass;

  public void visit(int version, int access, String className, String signature, String superClass, String[] interfaces) {
    asmClass = new AsmClass(access, className);
  }

  public FieldVisitor visitField(int access, String fieldName, String description, String signature, Object value) {
    AsmField field = new AsmField(access, fieldName, description, signature);
    asmClass.addField(field);
    return null;
  }

  public MethodVisitor visitMethod(int access, String methodName, String description, String signature, String[] exceptions) {
    AsmMethod method = new AsmMethod(access, methodName, description, signature, exceptions);
    asmClass.addMethod(method);
    return null;
  }

  public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
    return null;
  }

  public AsmClass getAsmClass() {
    return asmClass;
  }
}
