/*
w * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.java.bytecode.asm;

import java.util.Set;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;

public class AsmField extends AsmUnit {

  private String name;
  private AsmType type;
  private String[] classes;

  public AsmField(int access, String name, String descriptor, String descriptorWithGenerics) {
    super(access);
    this.access = access;
    this.name = name;
    this.type = new AsmType(Type.getType(descriptor));
    if (descriptorWithGenerics == null) {
      extractClasses(descriptor);
    } else {
      extractClasses(descriptorWithGenerics);
    }
  }

  @Override
  public boolean isStatic() {
    return (access & Opcodes.ACC_STATIC) != 0;
  }

  String getName() {
    return name;
  }

  AsmType getType() {
    return type;
  }

  String getPath() {
    return type.getPath();
  }

  private void extractClasses(String signature) {
    if (signature != null) {
      AsmSignatureVisitor signatureVisitor = new AsmSignatureVisitor();
      new SignatureReader(signature).acceptType(signatureVisitor);
      Set<String> internalNames = signatureVisitor.getInternalNames();
      classes = internalNames.toArray(new String[internalNames.size()]);
    }
  }

  String[] getClasses() {
    return classes;
  }

  boolean isArray() {
    return type.isArray();
  }

  boolean isObject() {
    return type.isObject();
  }

  boolean isPrimiteType() {
    return type.isPrimiteType();
  }
}
