/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import java.util.Arrays;
import java.util.List;
import org.sonar.java.ast.visitor.AstUtils;
import org.sonar.java.ast.visitor.AstVisitor;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.measures.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicApiVisitor
extends AstVisitor {
    static final String OVERRIDE_ANNOTATION_KEYWORD = "Override";
    private static final List<Integer> wantedTokens = Arrays.asList(14, 15, 9, 8, 157, 161, 10);

    @Override
    public List<Integer> getWantedTokens() {
        return wantedTokens;
    }

    @Override
    public void visitToken(DetailAST ast) {
        SourceCode currentResource = this.peekResource();
        if (this.isPublic(ast) && !this.isStaticFinalVariable(ast) && !this.isMethodWithOverrideAnnotation(ast) && !this.isEmptyDefaultConstructor(ast)) {
            currentResource.add(Metric.PUBLIC_API, 1.0);
            if (this.isDocumentedApi(ast)) {
                currentResource.add(Metric.PUBLIC_DOC_API, 1.0);
            }
        }
    }

    private boolean isEmptyDefaultConstructor(DetailAST ast) {
        return this.isConstructorWithoutParameters(ast) && ast.getLastChild().getChildCount() == 1;
    }

    private boolean isConstructorWithoutParameters(DetailAST ast) {
        return ast.getType() == 8 && ast.findFirstToken(20).getChildCount() == 0;
    }

    private boolean isMethodWithOverrideAnnotation(DetailAST ast) {
        if (this.isMethod(ast)) {
            DetailAST modifier = ast.findFirstToken(5);
            for (AST annotation = modifier.getFirstChild(); annotation != null; annotation = annotation.getNextSibling()) {
                if (!this.isAnnotation(annotation) || ((DetailAST)annotation).findFirstToken(58) == null) continue;
                String name = ((DetailAST)annotation).findFirstToken(58).getText();
                return OVERRIDE_ANNOTATION_KEYWORD.equals(name);
            }
        }
        return false;
    }

    private boolean isAnnotation(AST annotation) {
        return annotation.getType() == 159;
    }

    private boolean isMethod(DetailAST ast) {
        return ast.getType() == 9;
    }

    private boolean isPublic(DetailAST ast) {
        return AstUtils.isScope(AstUtils.getScope(ast), Scope.PUBLIC) || AstUtils.isType(ast, 161);
    }

    private boolean isDocumentedApi(DetailAST ast) {
        return this.getFileContents().getJavadocBefore(ast.getLineNo()) != null;
    }

    private boolean isStaticFinalVariable(DetailAST ast) {
        return (AstUtils.isClassVariable(ast) || AstUtils.isInterfaceVariable(ast)) && AstUtils.isFinal(ast) && AstUtils.isStatic(ast);
    }
}

