/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.text;

import java.io.IOException;
import java.io.Reader;

public class StringArrayReader
extends Reader {
    private String[] array;
    private int rowIndex = 0;
    private int rowIndexMark = 0;
    private int colIndex = 0;
    private int colIndexMark = 0;
    private static final char END_OF_LINE_CHAR = '\n';
    private boolean ready = true;

    public StringArrayReader(String[] array) {
        this.array = array;
    }

    public void close() throws IOException {
        this.array = null;
        this.ready = false;
    }

    public boolean ready() throws IOException {
        return this.ready;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) throws IOException {
        this.rowIndexMark = this.rowIndex;
        this.colIndexMark = this.colIndex;
    }

    public void reset() throws IOException {
        this.rowIndex = this.rowIndexMark;
        this.colIndex = this.colIndexMark;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.isEndOfArray()) {
            return -1;
        }
        if (this.isEndOfCurrentLine()) {
            this.switchToNewLine(cbuf, off);
            if (len > 1) {
                int numberOfReadChars = 1 + this.read(cbuf, off + 1, len - 1);
                return numberOfReadChars == 0 ? 1 : numberOfReadChars;
            }
            return 1;
        }
        if (this.isThereEnoughCharsOnCurrentLine(len)) {
            this.getCurrentLine().getChars(this.colIndex, this.colIndex + len, cbuf, off);
            this.colIndex += len;
            return len;
        }
        this.getCurrentLine().getChars(this.colIndex, this.getCurrentLine().length(), cbuf, off);
        int readLength = this.getCurrentLine().length() - this.colIndex;
        this.colIndex = this.getCurrentLine().length();
        int nextReadLength = this.read(cbuf, off + readLength, len - readLength);
        return readLength + (nextReadLength > -1 ? nextReadLength : 0);
    }

    private boolean isThereEnoughCharsOnCurrentLine(int len) {
        return this.colIndex + len <= this.getCurrentLine().length();
    }

    private boolean isEndOfArray() {
        return this.array == null || this.array.length == 0 || this.isEndOfCurrentLine() && this.rowIndex == this.array.length - 1;
    }

    private boolean isEndOfCurrentLine() {
        return this.colIndex >= this.getCurrentLine().length();
    }

    private String getCurrentLine() {
        return this.array[this.rowIndex];
    }

    private void switchToNewLine(char[] cbuf, int off) {
        cbuf[off] = 10;
        this.colIndex = 0;
        ++this.rowIndex;
    }
}

