/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.sensors;

import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.TextBlock;

public class BaseCommentsSensor extends ASTSensor {
  
  public void countCommentLines(TextBlock commentBlock, CommentLinesCounter counter, FileContents fileContent) {
    for (int i = 0; i < commentBlock.getText().length; i++) {
      String commentLine = commentBlock.getText()[i].trim();
      commentLine = commentLine.replace('*', ' ').replace('/', ' ').trim();
      if (commentLine.length() > 0) {
        counter.commentsLines++;
      } else {
        counter.blankCommentLines++;
      }
    }
    if (fileContent != null) {
      int startLine = commentBlock.getStartLineNo();
      String lineInFile = fileContent.getLines()[startLine-1].trim();
      if (lineInFile.charAt(0) != '/') {
        counter.commentLinesOnLineOfCode++;
      }
    }
  }
  
  public static class CommentLinesCounter {
    
    private int commentsLines;
    private int blankCommentLines;
    private int commentLinesOnLineOfCode;

    public int getCommentsLines() {
      return commentsLines;
    }

    public int getBlankCommentLines() {
      return blankCommentLines;
    }

    public int getCommentLinesOnLineOfCode() {
      return commentLinesOnLineOfCode;
    }
  }

}
