/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.sensors;

import java.util.List;
import java.util.Map;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;

public class BlankLineSensor extends ASTSensor {

  public void visitFile(DetailAST ast) {
    int blankLines = 0;
    boolean[] lineOutsideCBlock = new boolean[getFileContents().getLines().length];
    for ( int i = 0; i < getFileContents().getLines().length; i++) {
      lineOutsideCBlock[i] = true;
    }
    markLinesOutsideCBlock(lineOutsideCBlock);
    for (int i = 0; i < getFileContents().getLines().length; i++) {
      if (getFileContents().lineIsBlank(i) && lineOutsideCBlock[i]) {  
        blankLines++;
      }
    }
    peekResource().getMeasures().setBlankLines(blankLines);
  }
  
  private void markLinesOutsideCBlock(boolean[] lineOutsideCBlock) {
    for (List<TextBlock> commentBlocks : ((Map<Integer,List<TextBlock>>)getFileContents().getCComments()).values()) {
      for (TextBlock commentBlock : commentBlocks) {
        int start = commentBlock.getStartLineNo() - 1;
        int end = commentBlock.getEndLineNo() - 1;
        for ( int i = start; i < end; i++) {
          lineOutsideCBlock[i] = false;
        }
      }
    }
  }

}