/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.sonar.squid.entities.Measures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource
implements Comparable<Resource> {
    private final Type type;
    private final String name;
    private Resource parent;
    private final Measures measures;
    private SortedSet<Resource> children = new TreeSet<Resource>();

    public Resource(String name, Type type) {
        this.name = name;
        this.type = type;
        this.measures = new Measures(this);
    }

    public void addChild(Resource resource) {
        resource.setParent(this);
        if (!this.children.contains(resource)) {
            this.children.add(resource);
        }
    }

    public Measures getMeasures() {
        return this.measures;
    }

    public Resource getFirstChild() {
        return !this.children.isEmpty() ? this.children.first() : null;
    }

    public Resource getLastChild() {
        return !this.children.isEmpty() ? this.children.last() : null;
    }

    private void setParent(Resource parent) {
        this.parent = parent;
    }

    @Override
    public int compareTo(Resource resource) {
        return this.name.compareTo(resource.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.parent != null && !this.parent.getType().equals((Object)Type.PROJECT)) {
            return new StringBuilder(32).append(this.parent.getFullName()).append(".").append(this.getName()).toString();
        }
        return this.getName();
    }

    public Type getType() {
        return this.type;
    }

    public Resource getParent() {
        return this.parent;
    }

    public Set<Resource> getChildren() {
        return this.children;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)obj;
        return this.name.equals(resource.getName()) && this.type.equals((Object)resource.getType());
    }

    public int hashCode() {
        return this.name.hashCode() + this.type.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append((Object)this.getType()).append(" : ").append(this.getName()).append(":(").append(this.measures).append(")").append(IOUtils.LINE_SEPARATOR);
        for (Resource child : this.children) {
            String childTree = child.toString();
            StringTokenizer tokenizer = new StringTokenizer(childTree, IOUtils.LINE_SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                sb.append("-").append(tokenizer.nextToken()).append(IOUtils.LINE_SEPARATOR);
            }
        }
        return sb.toString();
    }

    public boolean contains(Resource wantedRes, boolean recursive) {
        if (this.children.contains(wantedRes)) {
            return true;
        }
        if (recursive) {
            for (Resource child : this.children) {
                if (!child.contains(wantedRes, recursive)) continue;
                return true;
            }
        }
        return false;
    }

    public Resource find(Resource wantedRes) {
        if (wantedRes.equals(this)) {
            return this;
        }
        for (Resource child : this.children) {
            Resource res = child.find(wantedRes);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public Resource find(String resourceName, Type resourceType) {
        return this.find(new Resource(resourceName, resourceType));
    }

    public Collection<Resource> find(Type resourceType) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        this.find(resources, resourceType);
        return resources;
    }

    private void find(Collection<Resource> resources, Type resourceType) {
        if (this.getType().equals((Object)resourceType)) {
            resources.add(this);
        }
        for (Resource child : this.children) {
            child.find(resources, resourceType);
        }
    }

    public final void compute() {
        for (Resource child : this.getChildren()) {
            child.compute();
        }
        this.getMeasures().consolidate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PROJECT,
        PACKAGE,
        FILE,
        CLASS,
        METHOD;

    }
}

