/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.handlers;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.squid.sensors.ASTSensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCheckstyleSquidBridge
extends Check {
    private static Logger logger = LoggerFactory.getLogger(JavaCheckstyleSquidBridge.class);
    private static List<ASTSensor> visitors;
    private static int[] allTokens;

    public static void setASTVisitors(List<ASTSensor> visitors) {
        JavaCheckstyleSquidBridge.visitors = visitors;
        TreeSet<Integer> sorter = new TreeSet<Integer>();
        for (ASTSensor visitor : visitors) {
            sorter.addAll(visitor.getWantedTokens());
            allTokens = new int[sorter.size()];
            int i = 0;
            for (Integer itSorted : sorter) {
                JavaCheckstyleSquidBridge.allTokens[i++] = itSorted;
            }
        }
    }

    public int[] getDefaultTokens() {
        return allTokens;
    }

    public void beginTree(DetailAST ast) {
        try {
            for (ASTSensor visitor : visitors) {
                visitor.setFileContents(this.getFileContents());
                visitor.visitFile(ast);
            }
        }
        catch (RuntimeException e) {
            logger.error("Error occurs when analysing :" + this.getFileContents().getFilename(), (Throwable)e);
        }
    }

    public void visitToken(DetailAST ast) {
        try {
            for (ASTSensor visitor : visitors) {
                if (!visitor.getWantedTokens().contains(ast.getType())) continue;
                visitor.visitToken(ast);
            }
        }
        catch (RuntimeException e) {
            logger.error("Error occurs when analysing :" + this.getFileContents().getFilename(), (Throwable)e);
        }
    }

    public void leaveToken(DetailAST ast) {
        try {
            for (int i = visitors.size() - 1; i >= 0; --i) {
                ASTSensor visitor = visitors.get(i);
                if (!visitor.getWantedTokens().contains(ast.getType())) continue;
                visitor.leaveToken(ast);
            }
        }
        catch (RuntimeException e) {
            logger.error("Error occurs when analysing :" + this.getFileContents().getFilename(), (Throwable)e);
        }
    }

    public void finishTree(DetailAST ast) {
        try {
            for (int i = visitors.size() - 1; i >= 0; --i) {
                ASTSensor visitor = visitors.get(i);
                visitor.leaveFile(ast);
            }
        }
        catch (RuntimeException e) {
            logger.error("Error occurs when analysing :" + this.getFileContents().getFilename(), (Throwable)e);
        }
    }
}

