/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.sensors;

import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import org.sonar.squid.sensors.ASTSensor;

public class BaseCommentsSensor
extends ASTSensor {
    public void countCommentLines(TextBlock commentBlock, CommentLinesCounter counter, FileContents fileContent) {
        for (int i = 0; i < commentBlock.getText().length; ++i) {
            String commentLine = commentBlock.getText()[i].trim();
            if ((commentLine = commentLine.replace('*', ' ').replace('/', ' ').trim()).length() > 0) {
                counter.commentsLines++;
                continue;
            }
            counter.blankCommentLines++;
        }
        if (fileContent != null) {
            int startLine = commentBlock.getStartLineNo();
            String lineInFile = fileContent.getLines()[startLine - 1].trim();
            if (lineInFile.charAt(0) != '/') {
                counter.commentLinesOnLineOfCode++;
            }
        }
    }

    public static class CommentLinesCounter {
        private int commentsLines;
        private int blankCommentLines;
        private int commentLinesOnLineOfCode;

        public int getCommentsLines() {
            return this.commentsLines;
        }

        public int getBlankCommentLines() {
            return this.blankCommentLines;
        }

        public int getCommentLinesOnLineOfCode() {
            return this.commentLinesOnLineOfCode;
        }
    }
}

