/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.sensors;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonar.squid.entities.Resource;
import org.sonar.squid.sensors.ASTSensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSensor
extends ASTSensor {
    @Override
    public List<Integer> getWantedTokens() {
        return Arrays.asList(8, 9);
    }

    @Override
    public void visitToken(DetailAST ast) {
        String methodName = this.extractMethodName(ast);
        this.addResource(new Resource(methodName, Resource.Type.METHOD));
    }

    @Override
    public void leaveToken(DetailAST ast) {
        this.popResource();
    }

    private String extractMethodName(DetailAST ast) {
        StringBuilder methodName = new StringBuilder(32);
        methodName.append(ast.findFirstToken(58).getText()).append("(");
        List<String> parameters = this.extractMethodParameters(ast);
        Iterator<String> i = parameters.iterator();
        while (i.hasNext()) {
            methodName.append(i.next());
            if (!i.hasNext()) continue;
            methodName.append(" ");
        }
        methodName.append(")");
        return methodName.toString();
    }

    private List<String> extractMethodParameters(DetailAST ast) {
        DetailAST paramAst = ast.findFirstToken(20);
        if (paramAst.getChildCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> parameters = new ArrayList<String>();
        DetailAST paramDefAst = paramAst.findFirstToken(21);
        parameters.add(paramDefAst.findFirstToken(13).getLastChild().getText());
        while ((paramDefAst = (DetailAST)paramDefAst.getNextSibling()) != null) {
            if (paramDefAst.getType() != 21) continue;
            parameters.add(paramDefAst.findFirstToken(13).getLastChild().getText());
        }
        return parameters;
    }
}

