/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.sensors;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import org.sonar.squid.entities.Resource;
import org.sonar.squid.sensors.ASTSensor;

public class PackageSensor
extends ASTSensor {
    public void visitFile(DetailAST ast) {
        if (ast == null) {
            return;
        }
        Resource packageRes = this.extractPackage(ast);
        if (this.peekResource().contains(packageRes, true)) {
            packageRes = this.peekResource().find(packageRes);
        }
        this.addResource(packageRes);
    }

    public void leaveFile(DetailAST ast) {
        if (ast == null) {
            return;
        }
        this.popResource();
    }

    private Resource extractPackage(DetailAST ast) {
        Resource packageRes;
        if (ast.getType() != 16) {
            packageRes = new Resource("[default]", Resource.Type.PACKAGE);
        } else {
            String packageName = FullIdent.createFullIdent((DetailAST)ast.getLastChild().getPreviousSibling()).getText();
            packageRes = new Resource(packageName, Resource.Type.PACKAGE);
        }
        return packageRes;
    }
}

