/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.sensors;

import java.util.Arrays;
import java.util.List;

import org.sonar.squid.entities.Resource;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

public class HeaderCommentSensor extends BaseCommentsSensor {
  
  @Override
  public List<Integer> getWantedTokens() {
    return Arrays.asList(TokenTypes.PACKAGE_DEF, TokenTypes.IMPORT, TokenTypes.CLASS_DEF);
  }

  public void visitToken(DetailAST ast) {
    Resource resource = peekResource();
    if (resource.getType() == Resource.Type.FILE &&
        resource.getMeasures().getHeaderCommentLines() == 0) {
      resource.getMeasures().setHeaderCommentLines(calculateHeaderCommentsLines(ast.getType()));
    }
  }

  private int calculateHeaderCommentsLines(int tokenType) {
    List<TextBlock> headerBlock = (List<TextBlock>)getFileContents().getCComments().get(1);
    if ( headerBlock != null && !headerBlock.isEmpty()) {
      TextBlock headerComment = headerBlock.get(0);
      // javadoc comments are also included in getCComments()
      boolean isJavadocComment = headerComment.getText()[0].startsWith( "/**");
      if ((isJavadocComment && tokenType == TokenTypes.PACKAGE_DEF) || !isJavadocComment) {
        CommentLinesCounter counter = new CommentLinesCounter();
        countCommentLines(headerComment, counter, null);
        return counter.getCommentsLines();
      }
    }
    return 0;
  }
}
