/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.sensors;

import java.util.Arrays;
import java.util.List;

import org.sonar.squid.entities.Resource;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

public class PublicApiSensor extends BaseCommentsSensor {

  @Override
  public List<Integer> getWantedTokens() {
    return Arrays.asList(TokenTypes.CLASS_DEF, TokenTypes.INTERFACE_DEF, TokenTypes.METHOD_DEF, TokenTypes.CTOR_DEF, 
        TokenTypes.ANNOTATION_DEF, TokenTypes.ANNOTATION_FIELD_DEF, TokenTypes.VARIABLE_DEF);
  }

  @Override
  public void visitToken(DetailAST ast) {
    Resource currentResource = peekResource();
    if (isScope(getScope(ast), Scope.PUBLIC) || isType(ast, TokenTypes.ANNOTATION_FIELD_DEF)) {
      // final static vars are not part of public API
      // to avoid noise on public constants class or interfaces
      if ((isClassVariable(ast) || isInterfaceVariable(ast)) && isFinal(ast) && isStatic(ast)) {
        return;
      }
      currentResource.getMeasures().addPublicApi();
      boolean isDocumented = getFileContents().getJavadocBefore(ast.getLineNo()) != null;
      if (isDocumented) {
        currentResource.getMeasures().addPublicDocumentedApi();
      }
    }
  }
 
}
