/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.utils;

import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.collections.Bag;
import org.apache.commons.collections.bag.HashBag;
import org.apache.commons.lang.ArrayUtils;

public class CountDistribution {

  public static Map<Integer,Integer> count(int[] distributionLimits, int[] values) {
    
    if (ArrayUtils.isEmpty(values)) {
      return null;
    }
    Bag countByRangeIndex = new HashBag();
    for (int value : values) {
      countByRangeIndex.add(getRangeIndex(value, distributionLimits));
    }
    
    Map<Integer,Integer> distribution = new TreeMap<Integer, Integer>();
    for (int index = 0; index < distributionLimits.length; index++) {
      distribution.put(distributionLimits[index], countByRangeIndex.getCount(index));
    }
    
    return distribution;
  }
  
  private static Integer getRangeIndex(int value, int[] bottomLimits) {
    for (int i = bottomLimits.length - 1; i > 0; i--) {
      if (value >= bottomLimits[i]) {
        return i;
      }
    }
    return 0;
  }
  
}
