/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class FilesDiscovery {

  /**
   * Scope is private because it's an utils class
   */
  private FilesDiscovery() {
  }

  /**
   * Traverses a specified node looking for files to check. Found files are
   * added to a specified list. Subdirectories are also traversed.
   *
   * @param aNode  the node to process
   * @param aFiles list to add found files to
   */
  public static List<File> traverse(File aNode) {
    List<File> files = new ArrayList<File>();
    if (aNode.canRead()) {
      if (aNode.isDirectory()) {
        final File[] nodes = aNode.listFiles();
        for (File node : nodes) {
          files.addAll(traverse(node));
        }
      } else if (aNode.isFile()) {
        files.add(aNode);
      }
    }
    return files;
  }
}
