/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import org.sonar.squid.entities.Resource;
import org.sonar.squid.handlers.Handler;
import org.sonar.squid.handlers.JavaCheckstyleHandler;
import org.sonar.squid.utils.FilesDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Squid {
    private static boolean anaylsePropertyAccessors = false;

    public static void setAnaylsePropertyAccessors(boolean newAnaylsePropertyAccessors) {
        anaylsePropertyAccessors = newAnaylsePropertyAccessors;
    }

    public static Resource analyze(File dirOrFileToAnalyze) {
        return Squid.analyze(dirOrFileToAnalyze, Charset.defaultCharset());
    }

    public static Resource analyze(File dirOrFileToAnalyze, Handler handler) {
        return Squid.analyze(FilesDiscovery.traverse(dirOrFileToAnalyze), Charset.defaultCharset(), handler);
    }

    public static Resource analyze(File dirOrFileToAnalyze, Charset charset) {
        if (dirOrFileToAnalyze == null) {
            throw new IllegalStateException("There is no directory or file to analyse as the File object is null.");
        }
        return Squid.analyze(FilesDiscovery.traverse(dirOrFileToAnalyze), charset, new JavaCheckstyleHandler(anaylsePropertyAccessors));
    }

    public static Resource analyze(Collection<File> filesToAnalyse) {
        return Squid.analyze(filesToAnalyse, Charset.defaultCharset(), new JavaCheckstyleHandler(anaylsePropertyAccessors));
    }

    public static Resource analyze(Collection<File> filesToAnalyse, Charset charset) {
        return Squid.analyze(filesToAnalyse, charset, new JavaCheckstyleHandler(anaylsePropertyAccessors));
    }

    public static Resource analyze(Collection<File> filesToAnalyse, Charset charset, Handler handler) {
        Resource project = new Resource("Project", Resource.Type.PROJECT);
        handler.analyzeSources(project, filesToAnalyse, charset);
        return project;
    }
}

