/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.handlers;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.squid.AnalysisException;
import org.sonar.squid.Squid;
import org.sonar.squid.entities.Resource;
import org.sonar.squid.handlers.Handler;
import org.sonar.squid.handlers.JavaCheckstyleSquidBridge;
import org.sonar.squid.sensors.ASTSensor;
import org.sonar.squid.sensors.AccessorSensor;
import org.sonar.squid.sensors.BlankLineSensor;
import org.sonar.squid.sensors.BranchSensor;
import org.sonar.squid.sensors.ClassSensor;
import org.sonar.squid.sensors.CommentSensors;
import org.sonar.squid.sensors.ComplexitySensor;
import org.sonar.squid.sensors.FileSensor;
import org.sonar.squid.sensors.HeaderCommentSensor;
import org.sonar.squid.sensors.LocSensor;
import org.sonar.squid.sensors.MethodSensor;
import org.sonar.squid.sensors.PackageSensor;
import org.sonar.squid.sensors.PublicApiSensor;
import org.sonar.squid.sensors.StatementSensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCheckstyleHandler
implements Handler {
    private boolean anaylseAccessors = false;

    public JavaCheckstyleHandler(boolean anaylseAccessors) {
        this.anaylseAccessors = anaylseAccessors;
    }

    private void launchCheckstyleEngine(Collection<File> files, Charset charset) throws AnalysisException {
        ErrorsListener listener = new ErrorsListener();
        Checker c = this.createChecker(charset, listener);
        File[] processedFiles = new File[files.size()];
        files.toArray(processedFiles);
        c.process(processedFiles);
        c.destroy();
        if (!listener.getErrors().isEmpty()) {
            throw listener.getErrors().get(0);
        }
    }

    private Checker createChecker(Charset charset, ErrorsListener errorsListener) {
        try {
            InputStream checkstyleConfig = JavaCheckstyleHandler.class.getClassLoader().getResourceAsStream("checkstyle-configuration.xml");
            String readenConfig = IOUtils.toString((InputStream)checkstyleConfig);
            readenConfig = readenConfig.replace("${charset}", charset.toString());
            checkstyleConfig = new ByteArrayInputStream(readenConfig.getBytes());
            Configuration config = ConfigurationLoader.loadConfiguration((InputStream)checkstyleConfig, (PropertyResolver)new PropertiesExpander(System.getProperties()), (boolean)false);
            Checker c = new Checker();
            c.configure(config);
            final Logger logger = LoggerFactory.getLogger(Squid.class);
            StreamLogger infoLogger = new StreamLogger(){

                public void log(String log) {
                    logger.info(log);
                }
            };
            StreamLogger errorLogger = new StreamLogger(){

                public void log(String log) {
                    logger.error(log);
                }
            };
            c.addListener((AuditListener)new DefaultLogger((OutputStream)infoLogger, true, (OutputStream)errorLogger, true));
            c.addListener((AuditListener)errorsListener);
            return c;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create Checkstyle Checker object with 'checkstyle-configuration.xml' as Checkstyle configuration file name", e);
        }
    }

    @Override
    public void analyzeSources(Resource project, Collection<File> filesToAnalyse, Charset charset) {
        List<ASTSensor> visitors = this.getVisitors();
        Stack<Resource> resourcesStack = new Stack<Resource>();
        resourcesStack.add(project);
        for (ASTSensor visitor : visitors) {
            visitor.setResourcesStack(resourcesStack);
        }
        JavaCheckstyleSquidBridge.setASTVisitors(visitors);
        this.launchCheckstyleEngine(filesToAnalyse, charset);
        project.compute();
    }

    private List<ASTSensor> getVisitors() {
        AccessorSensor accessorSensor = new AccessorSensor();
        ArrayList<ASTSensor> visitors = new ArrayList<ASTSensor>(Arrays.asList(new PackageSensor(), new FileSensor(), new HeaderCommentSensor(), new ClassSensor(), new MethodSensor(), accessorSensor, new LocSensor(), new BlankLineSensor(), new CommentSensors(), new PublicApiSensor(), new StatementSensor(), new BranchSensor(), new ComplexitySensor()));
        if (!this.anaylseAccessors) {
            visitors.remove(accessorSensor);
        }
        return visitors;
    }

    private static abstract class StreamLogger
    extends OutputStream {
        private StringBuilder builder = new StringBuilder(256);

        private StreamLogger() {
        }

        public void write(int byteToWrite) throws IOException {
            char character = (char)byteToWrite;
            if (character == '\n') {
                this.logAndResetBuffer();
            } else {
                this.builder.append(character);
            }
        }

        private void logAndResetBuffer() {
            this.log(this.builder.toString().trim());
            this.builder.setLength(0);
        }

        public abstract void log(String var1);

        public void close() throws IOException {
            if (this.builder.length() > 0) {
                this.logAndResetBuffer();
            }
            super.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorsListener
    implements AuditListener {
        private List<AnalysisException> errors = new ArrayList<AnalysisException>();

        private ErrorsListener() {
        }

        public void addError(AuditEvent evt) {
            if (evt.getMessage().contains("expecting EOF, found")) {
                return;
            }
            this.errors.add(new AnalysisException(evt.getMessage()));
        }

        public void addException(AuditEvent evt, Throwable throwable) {
            this.errors.add(new AnalysisException(evt.getMessage(), throwable));
        }

        public void auditFinished(AuditEvent evt) {
        }

        public void auditStarted(AuditEvent evt) {
        }

        public void fileFinished(AuditEvent evt) {
        }

        public void fileStarted(AuditEvent evt) {
        }

        public List<AnalysisException> getErrors() {
            return this.errors;
        }
    }
}

