/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.sensors;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.sonar.squid.AnalysisException;
import org.sonar.squid.entities.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASTSensor {
    private Stack<Resource> resourcesStack;
    private FileContents fileContents;

    public final void setFileContents(FileContents fileContents) {
        this.fileContents = fileContents;
    }

    public final FileContents getFileContents() {
        return this.fileContents;
    }

    public List<Integer> getWantedTokens() {
        return new ArrayList<Integer>();
    }

    public final void setResourcesStack(Stack<Resource> resourcesStack) {
        this.resourcesStack = resourcesStack;
    }

    public final void addResource(Resource child) {
        this.peekResource().addChild(child);
        this.resourcesStack.add(child);
    }

    public final void popResource() {
        this.resourcesStack.pop();
    }

    public final Resource peekResource() {
        return this.resourcesStack.peek();
    }

    public void visitFile(DetailAST ast) {
    }

    public void visitToken(DetailAST ast) {
    }

    public void leaveToken(DetailAST ast) {
    }

    public void leaveFile(DetailAST ast) {
    }

    protected AST findType(DetailAST ast) {
        DetailAST typeAst = ast.findFirstToken(13);
        if (typeAst != null) {
            return typeAst.getFirstChild();
        }
        return null;
    }

    protected boolean isClassVariable(DetailAST ast) {
        return ast.getType() == 10 && ast.getParent().getType() == 6 && this.isClass(ast.getParent().getParent());
    }

    protected boolean isClass(DetailAST ast) {
        return ast.getType() == 14 || ast.getType() == 154 || ast.getType() == 157;
    }

    protected boolean isInterfaceVariable(DetailAST ast) {
        return ast.getType() == 10 && ast.getParent().getType() == 6 && this.isInterface(ast.getParent().getParent());
    }

    protected boolean isInterface(DetailAST ast) {
        return ast.getType() == 15;
    }

    protected boolean isFinal(DetailAST detailAst) {
        return this.isModifier(detailAst, 39);
    }

    protected boolean isStatic(DetailAST detailAst) {
        return this.isModifier(detailAst, 64);
    }

    private boolean isModifier(DetailAST detailAst, int modifierType) {
        DetailAST modifiers = detailAst.findFirstToken(5);
        if (modifiers != null) {
            boolean isModifierMatching = modifiers.branchContains(modifierType);
            if (!isModifierMatching && this.isInterfaceVariable(detailAst)) {
                return modifierType == 64 || modifierType == 39;
            }
            return isModifierMatching;
        }
        return false;
    }

    protected Scope getScope(DetailAST ast) {
        Scope found;
        DetailAST modifierAst = ast.findFirstToken(5);
        Scope scope = found = modifierAst != null ? ScopeUtils.getScopeFromMods((DetailAST)modifierAst) : Scope.NOTHING;
        if (found.compareTo((Object)Scope.PACKAGE) == 0 && (ast.getType() == 9 || ast.getType() == 10)) {
            found = this.isScope(Scope.PACKAGE, found) && this.findParent(ast, 15) != null ? Scope.PUBLIC : found;
        }
        return found;
    }

    protected boolean isScope(Scope toCompare, Scope scope) {
        return scope.compareTo((Object)toCompare) == 0;
    }

    protected boolean isType(DetailAST ast, int type) {
        return ast.getType() == type;
    }

    protected DetailAST findParent(DetailAST ast, int tokenType) {
        DetailAST parent = ast.getParent();
        if (parent != null) {
            if (parent.getType() == tokenType) {
                return parent;
            }
            return this.findParent(parent, tokenType);
        }
        return null;
    }

    protected void ensureResourceType(Resource resource, Resource.Type type) {
        if (resource.getType() != type) {
            throw new AnalysisException("Resource " + resource.getFullName() + " must be of type " + (Object)((Object)type));
        }
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass());
    }
}

