/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.sensors;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import java.util.List;
import org.sonar.squid.sensors.ASTSensor;

public class BlankLineSensor
extends ASTSensor {
    public void visitFile(DetailAST ast) {
        int i;
        int blankLines = 0;
        boolean[] lineOutsideCBlock = new boolean[this.getFileContents().getLines().length];
        for (i = 0; i < this.getFileContents().getLines().length; ++i) {
            lineOutsideCBlock[i] = true;
        }
        this.markLinesOutsideCBlock(lineOutsideCBlock);
        for (i = 0; i < this.getFileContents().getLines().length; ++i) {
            if (!this.getFileContents().lineIsBlank(i) || !lineOutsideCBlock[i]) continue;
            ++blankLines;
        }
        this.peekResource().getMeasures().setBlankLines(blankLines);
    }

    private void markLinesOutsideCBlock(boolean[] lineOutsideCBlock) {
        for (List commentBlocks : this.getFileContents().getCComments().values()) {
            for (TextBlock commentBlock : commentBlocks) {
                int start = commentBlock.getStartLineNo() - 1;
                int end = commentBlock.getEndLineNo() - 1;
                for (int i = start; i < end; ++i) {
                    lineOutsideCBlock[i] = false;
                }
            }
        }
    }
}

